/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import java.util.List;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.child.BaseChildElementParser;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.IOParameter;
import org.apache.commons.lang3.StringUtils;

public class CallActivityXMLConverter
extends BaseBpmnXMLConverter {
    public CallActivityXMLConverter() {
        InParameterParser inParameterParser = new InParameterParser();
        this.childElementParsers.put(inParameterParser.getElementName(), inParameterParser);
        OutParameterParser outParameterParser = new OutParameterParser();
        this.childElementParsers.put(outParameterParser.getElementName(), outParameterParser);
    }

    public static String getXMLType() {
        return "callActivity";
    }

    public static Class<? extends BaseElement> getBpmnElementType() {
        return CallActivity.class;
    }

    @Override
    protected String getXMLElementName() {
        return "callActivity";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr) throws Exception {
        CallActivity callActivity = new CallActivity();
        BpmnXMLUtil.addXMLLocation((BaseElement)callActivity, xtr);
        callActivity.setCalledElement(xtr.getAttributeValue(null, "calledElement"));
        this.parseChildElements(this.getXMLElementName(), (BaseElement)callActivity, xtr);
        return callActivity;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, XMLStreamWriter xtw) throws Exception {
        CallActivity callActivity = (CallActivity)element;
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getCalledElement())) {
            xtw.writeAttribute("calledElement", callActivity.getCalledElement());
        }
    }

    @Override
    protected void writeExtensionChildElements(BaseElement element, XMLStreamWriter xtw) throws Exception {
        CallActivity callActivity = (CallActivity)element;
        this.writeIOParameters("in", callActivity.getInParameters(), xtw);
        this.writeIOParameters("out", callActivity.getOutParameters(), xtw);
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, XMLStreamWriter xtw) throws Exception {
    }

    private void writeIOParameters(String elementName, List<IOParameter> parameterList, XMLStreamWriter xtw) throws Exception {
        if (parameterList.size() == 0) {
            return;
        }
        for (IOParameter ioParameter : parameterList) {
            if (!this.didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                this.didWriteExtensionStartElement = true;
            }
            xtw.writeStartElement("activiti", elementName, "http://activiti.org/bpmn");
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSource())) {
                this.writeDefaultAttribute("source", ioParameter.getSource(), xtw);
            }
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSourceExpression())) {
                this.writeDefaultAttribute("sourceExpression", ioParameter.getSourceExpression(), xtw);
            }
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getTarget())) {
                this.writeDefaultAttribute("target", ioParameter.getTarget(), xtw);
            }
            xtw.writeEndElement();
        }
    }

    public class OutParameterParser
    extends BaseChildElementParser {
        @Override
        public String getElementName() {
            return "out";
        }

        @Override
        public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
            String source = xtr.getAttributeValue(null, "source");
            String sourceExpression = xtr.getAttributeValue(null, "sourceExpression");
            String target = xtr.getAttributeValue(null, "target");
            if ((StringUtils.isNotEmpty((CharSequence)source) || StringUtils.isNotEmpty((CharSequence)sourceExpression)) && StringUtils.isNotEmpty((CharSequence)target)) {
                IOParameter parameter = new IOParameter();
                if (StringUtils.isNotEmpty((CharSequence)sourceExpression)) {
                    parameter.setSourceExpression(sourceExpression);
                } else {
                    parameter.setSource(source);
                }
                parameter.setTarget(target);
                ((CallActivity)parentElement).getOutParameters().add(parameter);
            }
        }
    }

    public class InParameterParser
    extends BaseChildElementParser {
        @Override
        public String getElementName() {
            return "in";
        }

        @Override
        public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
            String source = xtr.getAttributeValue(null, "source");
            String sourceExpression = xtr.getAttributeValue(null, "sourceExpression");
            String target = xtr.getAttributeValue(null, "target");
            if ((StringUtils.isNotEmpty((CharSequence)source) || StringUtils.isNotEmpty((CharSequence)sourceExpression)) && StringUtils.isNotEmpty((CharSequence)target)) {
                IOParameter parameter = new IOParameter();
                if (StringUtils.isNotEmpty((CharSequence)sourceExpression)) {
                    parameter.setSourceExpression(sourceExpression);
                } else {
                    parameter.setSource(source);
                }
                parameter.setTarget(target);
                ((CallActivity)parentElement).getInParameters().add(parameter);
            }
        }
    }
}

