/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.jobs.FileScanListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class FileScanJob
implements Job {
    public static final String FILE_NAME = "FILE_NAME";
    public static final String FILE_SCAN_LISTENER_NAME = "FILE_SCAN_LISTENER_NAME";
    public static final String MINIMUM_UPDATE_AGE = "MINIMUM_UPDATE_AGE";
    private static final String LAST_MODIFIED_TIME = "LAST_MODIFIED_TIME";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap mergedJobDataMap = context.getMergedJobDataMap();
        SchedulerContext schedCtxt = null;
        try {
            schedCtxt = context.getScheduler().getContext();
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Error obtaining scheduler context.", e, false);
        }
        String fileName = mergedJobDataMap.getString(FILE_NAME);
        String listenerName = mergedJobDataMap.getString(FILE_SCAN_LISTENER_NAME);
        if (fileName == null) {
            throw new JobExecutionException("Required parameter 'FILE_NAME' not found in merged JobDataMap");
        }
        if (listenerName == null) {
            throw new JobExecutionException("Required parameter 'FILE_SCAN_LISTENER_NAME' not found in merged JobDataMap");
        }
        FileScanListener listener = (FileScanListener)schedCtxt.get(listenerName);
        if (listener == null) {
            throw new JobExecutionException("FileScanListener named '" + listenerName + "' not found in SchedulerContext");
        }
        long lastDate = -1L;
        if (mergedJobDataMap.containsKey(LAST_MODIFIED_TIME)) {
            lastDate = mergedJobDataMap.getLong(LAST_MODIFIED_TIME);
        }
        long minAge = 5000L;
        if (mergedJobDataMap.containsKey(MINIMUM_UPDATE_AGE)) {
            minAge = mergedJobDataMap.getLong(MINIMUM_UPDATE_AGE);
        }
        long maxAgeDate = System.currentTimeMillis() + minAge;
        long newDate = this.getLastModifiedDate(fileName);
        if (newDate < 0L) {
            this.log.warn("File '" + fileName + "' does not exist.");
            return;
        }
        if (lastDate > 0L && newDate > lastDate && newDate < maxAgeDate) {
            this.log.info("File '" + fileName + "' updated, notifying listener.");
            listener.fileUpdated(fileName);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("File '" + fileName + "' unchanged.");
        }
        context.getJobDetail().getJobDataMap().put(LAST_MODIFIED_TIME, newDate);
    }

    protected long getLastModifiedDate(String fileName) {
        File file;
        URL resource = Thread.currentThread().getContextClassLoader().getResource(fileName);
        String filePath = resource == null ? fileName : URLDecoder.decode(resource.getFile());
        int jarIndicator = filePath.indexOf(33);
        if (jarIndicator > 0) {
            filePath = filePath.substring(5, filePath.indexOf(33));
        }
        if (!(file = new File(filePath)).exists()) {
            return -1L;
        }
        return file.lastModified();
    }
}

