/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.rest.utils;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.syncope.common.types.SyncopeClientExceptionType;
import org.apache.syncope.common.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.common.validation.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

@Provider
public class RestClientExceptionMapper
implements ExceptionMapper<Exception>,
ResponseExceptionMapper<Exception> {
    private static final Logger LOG = LoggerFactory.getLogger(RestClientExceptionMapper.class);

    public Response toResponse(Exception exception) {
        throw new UnsupportedOperationException("Call of toResponse() method is not expected in RestClientExceptionnMapper");
    }

    public Exception fromResponse(Response response) {
        Object ex = null;
        int statusCode = response.getStatus();
        SyncopeClientCompositeErrorException scce = this.checkCompositeException(response);
        ex = scce != null ? scce : (statusCode == 401 ? new AccessControlException("Remote unauthorized exception") : (statusCode == 400 ? new BadRequestException() : new WebServiceException(String.format("Remote exception with status code: %s", Response.Status.fromStatusCode((int)statusCode).name()))));
        LOG.error("Exception thrown by REST methods: " + ((Throwable)ex).getMessage(), (Throwable)ex);
        return ex;
    }

    private SyncopeClientCompositeErrorException checkCompositeException(Response response) {
        int statusCode = response.getStatus();
        List exTypesInHeaders = (List)response.getHeaders().get((Object)"ExceptionType");
        if (exTypesInHeaders == null) {
            LOG.debug("No ExceptionType provided");
            return null;
        }
        SyncopeClientCompositeErrorException compException = new SyncopeClientCompositeErrorException(HttpStatus.valueOf((int)statusCode));
        HashSet<String> handledExceptions = new HashSet<String>();
        for (Object exceptionTypeValue : exTypesInHeaders) {
            String exTypeAsString = (String)exceptionTypeValue;
            SyncopeClientExceptionType exceptionType = null;
            try {
                exceptionType = SyncopeClientExceptionType.getFromHeaderValue((String)exTypeAsString);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Unexpected value of ExceptionType: " + exTypeAsString, (Throwable)e);
            }
            if (exceptionType == null) continue;
            handledExceptions.add(exTypeAsString);
            SyncopeClientException clientException = new SyncopeClientException();
            clientException.setType(exceptionType);
            if (response.getHeaders().get((Object)exceptionType.getElementHeaderName()) != null && !((List)response.getHeaders().get((Object)exceptionType.getElementHeaderName())).isEmpty()) {
                List elObjectList = (List)response.getHeaders().get((Object)exceptionType.getElementHeaderName());
                ArrayList<String> elStringList = new ArrayList<String>();
                for (Object elementObject : elObjectList) {
                    if (!(elementObject instanceof String)) continue;
                    elStringList.add((String)elementObject);
                }
                clientException.setElements(elStringList);
            }
            compException.addException(clientException);
        }
        exTypesInHeaders.removeAll(handledExceptions);
        if (!exTypesInHeaders.isEmpty()) {
            LOG.error("Unmanaged exceptions: " + exTypesInHeaders);
        }
        if (compException.hasExceptions()) {
            return compException;
        }
        return null;
    }
}

