/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.util;

import java.util.AbstractMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.to.EventCategoryTO;
import org.apache.syncope.common.types.AuditElements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerEventUtils {
    private static Logger LOG = LoggerFactory.getLogger(LoggerEventUtils.class);

    public static Map.Entry<EventCategoryTO, AuditElements.Result> parseEventCategory(String event) {
        EventCategoryTO eventCategoryTO = new EventCategoryTO();
        AuditElements.Result condition = null;
        if (StringUtils.isNotEmpty((CharSequence)event)) {
            LOG.debug("Parse event {}", (Object)event);
            String[] elements = event.substring(1, event.length() - 1).split("\\]:\\[");
            LOG.debug("Found {} elements", (Object)elements.length);
            if (elements.length == 1) {
                eventCategoryTO.setType(AuditElements.EventCategoryType.CUSTOM);
                condition = AuditElements.Result.SUCCESS;
                eventCategoryTO.getEvents().add(event);
            } else {
                AuditElements.EventCategoryType type;
                LOG.debug("Type {}", (Object)elements[0]);
                if (AuditElements.EventCategoryType.PROPAGATION.toString().equals(elements[0])) {
                    type = AuditElements.EventCategoryType.PROPAGATION;
                } else if (AuditElements.EventCategoryType.SYNCHRONIZATION.toString().equals(elements[0])) {
                    type = AuditElements.EventCategoryType.SYNCHRONIZATION;
                } else {
                    try {
                        type = AuditElements.EventCategoryType.valueOf(elements[0]);
                    }
                    catch (Exception e) {
                        type = AuditElements.EventCategoryType.CUSTOM;
                    }
                }
                eventCategoryTO.setType(type);
                LOG.debug("Category {}", (Object)elements[1]);
                eventCategoryTO.setCategory(StringUtils.isNotEmpty((CharSequence)elements[1]) ? elements[1] : null);
                LOG.debug("Sub-category {}", (Object)elements[2]);
                eventCategoryTO.setSubcategory(StringUtils.isNotEmpty((CharSequence)elements[2]) ? elements[2] : null);
                if (elements.length > 3 && StringUtils.isNotEmpty((CharSequence)elements[3])) {
                    LOG.debug("Event {}", (Object)elements[3]);
                    eventCategoryTO.getEvents().add(elements[3]);
                }
                if (elements.length > 4) {
                    LOG.debug("Result condition {}", (Object)elements[4]);
                    condition = AuditElements.Result.valueOf(elements[4].toUpperCase());
                }
            }
        }
        return new AbstractMap.SimpleEntry<EventCategoryTO, Object>(eventCategoryTO, condition);
    }

    public static String buildEvent(AuditElements.EventCategoryType type, String category, String subcategory, String event, AuditElements.Result resultValueCondition) {
        StringBuilder eventBuilder = new StringBuilder();
        eventBuilder.append('[');
        if (type != null) {
            if (StringUtils.isNotBlank((CharSequence)type.toString())) {
                eventBuilder.append(type.toString());
            } else {
                eventBuilder.append(type.name());
            }
        }
        eventBuilder.append(']');
        eventBuilder.append(":");
        eventBuilder.append('[');
        if (StringUtils.isNotBlank((CharSequence)category)) {
            eventBuilder.append(category);
        }
        eventBuilder.append(']');
        eventBuilder.append(":");
        eventBuilder.append('[');
        if (StringUtils.isNotBlank((CharSequence)subcategory)) {
            eventBuilder.append(subcategory);
        }
        eventBuilder.append(']');
        eventBuilder.append(":");
        eventBuilder.append('[');
        if (StringUtils.isNotBlank((CharSequence)event)) {
            eventBuilder.append(event);
        }
        eventBuilder.append(']');
        if (resultValueCondition != null) {
            eventBuilder.append(":");
            eventBuilder.append('[');
            eventBuilder.append((Object)resultValueCondition);
            eventBuilder.append(']');
        }
        return eventBuilder.toString();
    }
}

