/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class RunTest
extends Task {
    private String basedir;
    private String testsuite = "";
    private String referenceJar = "";
    private String refVersion = "";

    public void setTestSuite(String str) {
        this.testsuite = str;
    }

    public void setBasedir(String str) {
        this.basedir = str;
    }

    public void setReference(String str) {
        this.referenceJar = str;
    }

    public void setRefVersion(String str) {
        this.refVersion = str;
    }

    public void execute() throws BuildException {
        this.runReference();
        this.testNewBuild();
    }

    protected void testNewBuild() {
        try {
            URLClassLoader loader = new URLClassLoader(this.createUrls("build/fop.jar"));
            Map diff = this.runConverter(loader, "areatree", "reference/output/");
            if (diff != null && !diff.isEmpty()) {
                System.out.println("====================================");
                System.out.println("The following files differ:");
                boolean broke = false;
                for (Object fname : diff.keySet()) {
                    Boolean pass = (Boolean)diff.get(fname);
                    System.out.println("file: " + fname + " - reference success: " + pass);
                    if (!pass.booleanValue()) continue;
                    broke = true;
                }
                if (broke) {
                    throw new BuildException("Working tests have been changed.");
                }
            }
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
    }

    protected void runReference() throws BuildException {
        File f = new File(this.basedir + "/reference/output/");
        try {
            URLClassLoader loader = new URLClassLoader(this.createUrls(this.referenceJar));
            boolean failed = false;
            try {
                Class<?> cla = Class.forName("org.apache.fop.apps.Fop", true, loader);
                Method get = cla.getMethod("getVersion", new Class[0]);
                if (!get.invoke(null, new Object[0]).equals(this.refVersion)) {
                    throw new BuildException("Reference jar is not correct version it must be: " + this.refVersion);
                }
            }
            catch (IllegalAccessException iae) {
                failed = true;
            }
            catch (IllegalArgumentException are) {
                failed = true;
            }
            catch (InvocationTargetException are) {
                failed = true;
            }
            catch (ClassNotFoundException are) {
                failed = true;
            }
            catch (NoSuchMethodException are) {
                failed = true;
            }
            if (failed) {
                throw new BuildException("Reference jar could not be found in: " + this.basedir + "/reference/");
            }
            f.mkdirs();
            this.runConverter(loader, "reference/output/", null);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
    }

    protected Map runConverter(ClassLoader loader, String dest, String compDir) {
        String converter = "org.apache.fop.tools.TestConverter";
        Map diff = null;
        try {
            Class<?> cla = Class.forName(converter, true, loader);
            Object tc = cla.newInstance();
            Method meth = cla.getMethod("setBaseDir", String.class);
            meth.invoke(tc, this.basedir);
            meth = cla.getMethod("runTests", String.class, String.class, String.class);
            diff = (Map)meth.invoke(tc, this.testsuite, dest, compDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return diff;
    }

    private URL[] createUrls(String mainJar) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(new File(mainJar).toURI().toURL());
        File[] libFiles = new File("lib").listFiles();
        for (int i = 0; i < libFiles.length; ++i) {
            if (!libFiles[i].getPath().endsWith(".jar")) continue;
            urls.add(libFiles[i].toURI().toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

