/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.color.ICC_Profile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.extensions.xmp.XMPMetadata;
import org.apache.fop.pdf.PDFAMode;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFConformanceException;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEmbeddedFile;
import org.apache.fop.pdf.PDFEmbeddedFiles;
import org.apache.fop.pdf.PDFEncryptionManager;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFMetadata;
import org.apache.fop.pdf.PDFNames;
import org.apache.fop.pdf.PDFNumsArray;
import org.apache.fop.pdf.PDFOutputIntent;
import org.apache.fop.pdf.PDFPageLabels;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFXMode;
import org.apache.fop.pdf.Version;
import org.apache.fop.pdf.VersionController;
import org.apache.fop.render.pdf.PDFConfigurationConstants;
import org.apache.fop.render.pdf.extensions.PDFEmbeddedFileExtensionAttachment;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.schemas.XMPBasicAdapter;
import org.apache.xmlgraphics.xmp.schemas.XMPBasicSchema;

class PDFRenderingUtil
implements PDFConfigurationConstants {
    private static Log log = LogFactory.getLog(PDFRenderingUtil.class);
    private FOUserAgent userAgent;
    protected PDFDocument pdfDoc;
    protected PDFAMode pdfAMode = PDFAMode.DISABLED;
    protected PDFXMode pdfXMode = PDFXMode.DISABLED;
    protected PDFEncryptionParams encryptionParams;
    protected Map filterMap;
    protected PDFICCStream outputProfile;
    protected PDFICCBasedColorSpace sRGBColorSpace;
    protected boolean disableSRGBColorSpace = false;
    protected String outputProfileURI;
    protected Version maxPDFVersion;

    PDFRenderingUtil(FOUserAgent userAgent) {
        this.userAgent = userAgent;
        this.initialize();
    }

    private static boolean booleanValueOf(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        throw new IllegalArgumentException("Boolean or \"true\" or \"false\" expected.");
    }

    private void initialize() {
        Object disableSRGBColorSpace;
        String s;
        Object noPrintHQ;
        Object noAssembleDoc;
        Object noAccessContent;
        Object noFillInForms;
        Object noAnnotations;
        Object noEditContent;
        Object noCopyContent;
        Object noPrint;
        String ownerPassword;
        String userPassword;
        PDFEncryptionParams params = (PDFEncryptionParams)this.userAgent.getRendererOptions().get("encryption-params");
        if (params != null) {
            this.encryptionParams = params;
        }
        if ((userPassword = (String)this.userAgent.getRendererOptions().get("user-password")) != null) {
            this.getEncryptionParams().setUserPassword(userPassword);
        }
        if ((ownerPassword = (String)this.userAgent.getRendererOptions().get("owner-password")) != null) {
            this.getEncryptionParams().setOwnerPassword(ownerPassword);
        }
        if ((noPrint = this.userAgent.getRendererOptions().get("noprint")) != null) {
            this.getEncryptionParams().setAllowPrint(!PDFRenderingUtil.booleanValueOf(noPrint));
        }
        if ((noCopyContent = this.userAgent.getRendererOptions().get("nocopy")) != null) {
            this.getEncryptionParams().setAllowCopyContent(!PDFRenderingUtil.booleanValueOf(noCopyContent));
        }
        if ((noEditContent = this.userAgent.getRendererOptions().get("noedit")) != null) {
            this.getEncryptionParams().setAllowEditContent(!PDFRenderingUtil.booleanValueOf(noEditContent));
        }
        if ((noAnnotations = this.userAgent.getRendererOptions().get("noannotations")) != null) {
            this.getEncryptionParams().setAllowEditAnnotations(!PDFRenderingUtil.booleanValueOf(noAnnotations));
        }
        if ((noFillInForms = this.userAgent.getRendererOptions().get("nofillinforms")) != null) {
            this.getEncryptionParams().setAllowFillInForms(!PDFRenderingUtil.booleanValueOf(noFillInForms));
        }
        if ((noAccessContent = this.userAgent.getRendererOptions().get("noaccesscontent")) != null) {
            this.getEncryptionParams().setAllowAccessContent(!PDFRenderingUtil.booleanValueOf(noAccessContent));
        }
        if ((noAssembleDoc = this.userAgent.getRendererOptions().get("noassembledoc")) != null) {
            this.getEncryptionParams().setAllowAssembleDocument(!PDFRenderingUtil.booleanValueOf(noAssembleDoc));
        }
        if ((noPrintHQ = this.userAgent.getRendererOptions().get("noprinthq")) != null) {
            this.getEncryptionParams().setAllowPrintHq(!PDFRenderingUtil.booleanValueOf(noPrintHQ));
        }
        if ((s = (String)this.userAgent.getRendererOptions().get("pdf-a-mode")) != null) {
            this.pdfAMode = PDFAMode.valueOf(s);
        }
        if (this.pdfAMode.isPDFA1LevelA()) {
            this.userAgent.getRendererOptions().put("accessibility", Boolean.TRUE);
        }
        if ((s = (String)this.userAgent.getRendererOptions().get("pdf-x-mode")) != null) {
            this.pdfXMode = PDFXMode.valueOf(s);
        }
        if ((s = (String)this.userAgent.getRendererOptions().get("output-profile")) != null) {
            this.outputProfileURI = s;
        }
        if ((disableSRGBColorSpace = this.userAgent.getRendererOptions().get("disable-srgb-colorspace")) != null) {
            this.disableSRGBColorSpace = PDFRenderingUtil.booleanValueOf(disableSRGBColorSpace);
        }
    }

    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setAMode(PDFAMode mode) {
        this.pdfAMode = mode;
    }

    public void setXMode(PDFXMode mode) {
        this.pdfXMode = mode;
    }

    public void setOutputProfileURI(String outputProfileURI) {
        this.outputProfileURI = outputProfileURI;
    }

    public void setDisableSRGBColorSpace(boolean disable) {
        this.disableSRGBColorSpace = disable;
    }

    public void setFilterMap(Map filterMap) {
        this.filterMap = filterMap;
    }

    PDFEncryptionParams getEncryptionParams() {
        if (this.encryptionParams == null) {
            this.encryptionParams = new PDFEncryptionParams();
        }
        return this.encryptionParams;
    }

    private void updateInfo() {
        PDFInfo info = this.pdfDoc.getInfo();
        info.setCreator(this.userAgent.getCreator());
        info.setCreationDate(this.userAgent.getCreationDate());
        info.setAuthor(this.userAgent.getAuthor());
        info.setTitle(this.userAgent.getTitle());
        info.setSubject(this.userAgent.getSubject());
        info.setKeywords(this.userAgent.getKeywords());
    }

    private void updatePDFProfiles() {
        this.pdfDoc.getProfile().setPDFAMode(this.pdfAMode);
        this.pdfDoc.getProfile().setPDFXMode(this.pdfXMode);
    }

    private void addsRGBColorSpace() throws IOException {
        if (this.disableSRGBColorSpace) {
            if (this.pdfAMode != PDFAMode.DISABLED || this.pdfXMode != PDFXMode.DISABLED || this.outputProfileURI != null) {
                throw new IllegalStateException("It is not possible to disable the sRGB color space if PDF/A or PDF/X functionality is enabled or an output profile is set!");
            }
        } else {
            if (this.sRGBColorSpace != null) {
                return;
            }
            this.sRGBColorSpace = PDFICCBasedColorSpace.setupsRGBAsDefaultRGBColorSpace(this.pdfDoc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDefaultOutputProfile() throws IOException {
        if (this.outputProfile != null) {
            return;
        }
        InputStream in = null;
        if (this.outputProfileURI != null) {
            ICC_Profile profile;
            this.outputProfile = this.pdfDoc.getFactory().makePDFICCStream();
            Source src = this.getUserAgent().resolveURI(this.outputProfileURI);
            if (src == null) {
                throw new IOException("Output profile not found: " + this.outputProfileURI);
            }
            in = src instanceof StreamSource ? ((StreamSource)src).getInputStream() : new URL(src.getSystemId()).openStream();
            try {
                profile = ColorProfileUtil.getICC_Profile((InputStream)in);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            this.outputProfile.setColorSpace(profile, null);
        } else {
            this.outputProfile = this.sRGBColorSpace.getICCStream();
        }
    }

    private void addPDFA1OutputIntent() throws IOException {
        this.addDefaultOutputProfile();
        String desc = ColorProfileUtil.getICCProfileDescription((ICC_Profile)this.outputProfile.getICCProfile());
        PDFOutputIntent outputIntent = this.pdfDoc.getFactory().makeOutputIntent();
        outputIntent.setSubtype("GTS_PDFA1");
        outputIntent.setDestOutputProfile(this.outputProfile);
        outputIntent.setOutputConditionIdentifier(desc);
        outputIntent.setInfo(outputIntent.getOutputConditionIdentifier());
        this.pdfDoc.getRoot().addOutputIntent(outputIntent);
    }

    private void addPDFXOutputIntent() throws IOException {
        this.addDefaultOutputProfile();
        String desc = ColorProfileUtil.getICCProfileDescription((ICC_Profile)this.outputProfile.getICCProfile());
        int deviceClass = this.outputProfile.getICCProfile().getProfileClass();
        if (deviceClass != 2) {
            throw new PDFConformanceException(this.pdfDoc.getProfile().getPDFXMode() + " requires that" + " the DestOutputProfile be an Output Device Profile. " + desc + " does not match that requirement.");
        }
        PDFOutputIntent outputIntent = this.pdfDoc.getFactory().makeOutputIntent();
        outputIntent.setSubtype("GTS_PDFX");
        outputIntent.setDestOutputProfile(this.outputProfile);
        outputIntent.setOutputConditionIdentifier(desc);
        outputIntent.setInfo(outputIntent.getOutputConditionIdentifier());
        this.pdfDoc.getRoot().addOutputIntent(outputIntent);
    }

    public void renderXMPMetadata(XMPMetadata metadata) {
        Metadata docXMP = metadata.getMetadata();
        Metadata fopXMP = PDFMetadata.createXMPFromPDFDocument(this.pdfDoc);
        fopXMP.mergeInto(docXMP);
        XMPBasicAdapter xmpBasic = XMPBasicSchema.getAdapter((Metadata)docXMP);
        xmpBasic.setMetadataDate(new Date());
        PDFMetadata.updateInfoFromMetadata(docXMP, this.pdfDoc.getInfo());
        PDFMetadata pdfMetadata = this.pdfDoc.getFactory().makeMetadata(docXMP, metadata.isReadOnly());
        this.pdfDoc.getRoot().setMetadata(pdfMetadata);
    }

    public void generateDefaultXMPMetadata() {
        if (this.pdfDoc.getRoot().getMetadata() == null) {
            Metadata xmp = PDFMetadata.createXMPFromPDFDocument(this.pdfDoc);
            PDFMetadata pdfMetadata = this.pdfDoc.getFactory().makeMetadata(xmp, true);
            this.pdfDoc.getRoot().setMetadata(pdfMetadata);
        }
    }

    public PDFDocument setupPDFDocument(OutputStream out) throws IOException {
        String producer;
        if (this.pdfDoc != null) {
            throw new IllegalStateException("PDFDocument already set up");
        }
        String string = producer = this.userAgent.getProducer() != null ? this.userAgent.getProducer() : "";
        if (this.maxPDFVersion == null) {
            this.pdfDoc = new PDFDocument(producer);
        } else {
            VersionController controller = VersionController.getFixedVersionController(this.maxPDFVersion);
            this.pdfDoc = new PDFDocument(producer, controller);
        }
        this.updateInfo();
        this.updatePDFProfiles();
        this.pdfDoc.setFilterMap(this.filterMap);
        this.pdfDoc.outputHeader(out);
        PDFEncryptionManager.setupPDFEncryption(this.encryptionParams, this.pdfDoc);
        this.addsRGBColorSpace();
        if (this.outputProfileURI != null) {
            this.addDefaultOutputProfile();
        }
        if (this.pdfXMode != PDFXMode.DISABLED) {
            log.debug((Object)(this.pdfXMode + " is active."));
            log.warn((Object)("Note: " + this.pdfXMode + " support is work-in-progress and not fully implemented, yet!"));
            this.addPDFXOutputIntent();
        }
        if (this.pdfAMode.isPDFA1LevelB()) {
            log.debug((Object)("PDF/A is active. Conformance Level: " + this.pdfAMode));
            this.addPDFA1OutputIntent();
        }
        this.pdfDoc.enableAccessibility(this.userAgent.isAccessibilityEnabled());
        return this.pdfDoc;
    }

    public void generatePageLabel(int pageIndex, String pageNumber) {
        PDFPageLabels pageLabels = this.pdfDoc.getRoot().getPageLabels();
        if (pageLabels == null) {
            pageLabels = this.pdfDoc.getFactory().makePageLabels();
            this.pdfDoc.getRoot().setPageLabels(pageLabels);
        }
        PDFNumsArray nums = pageLabels.getNums();
        PDFDictionary dict = new PDFDictionary(nums);
        dict.put("P", pageNumber);
        nums.put(pageIndex, (Object)dict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEmbeddedFile(PDFEmbeddedFileExtensionAttachment embeddedFile) throws IOException {
        PDFArray nameArray;
        this.pdfDoc.getProfile().verifyEmbeddedFilesAllowed();
        PDFNames names = this.pdfDoc.getRoot().getNames();
        if (names == null) {
            names = this.pdfDoc.getFactory().makeNames();
            this.pdfDoc.getRoot().setNames(names);
        }
        PDFEmbeddedFile file = new PDFEmbeddedFile();
        this.pdfDoc.registerObject(file);
        Source src = this.getUserAgent().resolveURI(embeddedFile.getSrc());
        InputStream in = ImageUtil.getInputStream((Source)src);
        if (in == null) {
            throw new FileNotFoundException(embeddedFile.getSrc());
        }
        try {
            OutputStream out = file.getBufferOutputStream();
            IOUtils.copyLarge((InputStream)in, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        PDFDictionary dict = new PDFDictionary();
        dict.put("F", file);
        String filename = PDFText.toPDFString(embeddedFile.getFilename(), '_');
        PDFFileSpec fileSpec = new PDFFileSpec(filename);
        fileSpec.setEmbeddedFile(dict);
        if (embeddedFile.getDesc() != null) {
            fileSpec.setDescription(embeddedFile.getDesc());
        }
        this.pdfDoc.registerObject(fileSpec);
        PDFEmbeddedFiles embeddedFiles = names.getEmbeddedFiles();
        if (embeddedFiles == null) {
            embeddedFiles = new PDFEmbeddedFiles();
            this.pdfDoc.assignObjectNumber(embeddedFiles);
            this.pdfDoc.addTrailerObject(embeddedFiles);
            names.setEmbeddedFiles(embeddedFiles);
        }
        if ((nameArray = embeddedFiles.getNames()) == null) {
            nameArray = new PDFArray();
            embeddedFiles.setNames(nameArray);
        }
        String name = PDFText.toPDFString(filename);
        nameArray.add(name);
        nameArray.add(new PDFReference(fileSpec));
    }

    public void setPDFVersion(String version) {
        this.maxPDFVersion = Version.getValueOf(version);
    }
}

