/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.Map;
import org.activiti.engine.impl.cmd.NeedsActiveExecutionCmd;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class SetExecutionVariablesCmd
extends NeedsActiveExecutionCmd<Object> {
    private static final long serialVersionUID = 1L;
    protected Map<String, ? extends Object> variables;
    protected boolean isLocal;

    public SetExecutionVariablesCmd(String executionId, Map<String, ? extends Object> variables, boolean isLocal) {
        super(executionId);
        this.variables = variables;
        this.isLocal = isLocal;
    }

    @Override
    protected Object execute(CommandContext commandContext, ExecutionEntity execution) {
        if (this.isLocal) {
            execution.setVariablesLocal(this.variables);
        } else {
            execution.setVariables(this.variables);
        }
        return null;
    }

    @Override
    protected String getSuspendedExceptionMessage() {
        return "Cannot set variables because execution '" + this.executionId + "' is suspended";
    }
}

