/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource.caching.version;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.request.resource.caching.version.IResourceVersion;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDigestResourceVersion
implements IResourceVersion {
    private static final Logger log = LoggerFactory.getLogger(MessageDigestResourceVersion.class);
    private static final String DEFAULT_ALGORITHM = "MD5";
    private static final int DEFAULT_BUFFER_BYTES = 8192;
    private static final Bytes DEFAULT_BUFFER_SIZE = Bytes.bytes((long)8192L);
    private final String algorithm;
    private final Bytes bufferSize;

    public MessageDigestResourceVersion() {
        this(DEFAULT_ALGORITHM, DEFAULT_BUFFER_SIZE);
    }

    public MessageDigestResourceVersion(String algorithm) {
        this(algorithm, DEFAULT_BUFFER_SIZE);
    }

    public MessageDigestResourceVersion(String algorithm, Bytes bufferSize) {
        this.algorithm = (String)Args.notEmpty((CharSequence)algorithm, (String)"algorithm");
        this.bufferSize = (Bytes)Args.notNull((Object)bufferSize, (String)"bufferSize");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion(IStaticCacheableResource resource) {
        String string;
        IResourceStream stream = resource.getCacheableResourceStream();
        if (stream == null) {
            return null;
        }
        InputStream inputStream = stream.getInputStream();
        try {
            byte[] hash = this.computeDigest(inputStream);
            string = Strings.toHexString((byte[])hash);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.close((Closeable)stream);
                throw throwable;
            }
            catch (IOException e) {
                log.warn("unable to compute hash for " + resource, (Throwable)e);
                return null;
            }
            catch (ResourceStreamNotFoundException e) {
                log.warn("unable to locate resource for " + resource, (Throwable)e);
                return null;
            }
        }
        IOUtils.close((Closeable)stream);
        return string;
    }

    protected MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new WicketRuntimeException("message digest " + this.algorithm + " not found", e);
        }
    }

    protected byte[] computeDigest(InputStream inputStream) throws IOException {
        int len;
        MessageDigest digest = this.getMessageDigest();
        int bufferLen = (int)Math.min(Integer.MAX_VALUE, this.bufferSize.bytes());
        byte[] buf = new byte[bufferLen];
        while ((len = inputStream.read(buf)) != -1) {
            digest.update(buf, 0, len);
        }
        return digest.digest();
    }
}

