/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.parser;

import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Signal;
import org.apache.commons.lang.StringUtils;

public class SignalParser
implements BpmnXMLConstants {
    public void parse(XMLStreamReader xtr, BpmnModel model) throws Exception {
        String signalId = xtr.getAttributeValue(null, "id");
        String signalName = xtr.getAttributeValue(null, "name");
        if (StringUtils.isEmpty((String)signalId)) {
            model.addProblem("signal must have an id", xtr);
        } else if (StringUtils.isEmpty((String)signalName)) {
            model.addProblem("signal with id '" + signalId + "' has no name", xtr);
        } else {
            for (Signal signal : model.getSignals()) {
                if (!signal.getName().equals(signalName)) continue;
                model.addProblem("duplicate signal name", xtr);
            }
            Signal signal = new Signal(signalId, signalName);
            String scope = xtr.getAttributeValue("http://activiti.org/bpmn", "scope");
            if (scope != null) {
                if (!scope.equals("global") && !scope.equals("processInstance")) {
                    model.addProblem("Invalid value for 'scope'. Only 'global' and 'processInstance' is supported, but value is '" + scope + "'", (BaseElement)signal);
                }
                signal.setScope(scope);
            }
            BpmnXMLUtil.addXMLLocation((BaseElement)signal, xtr);
            model.addSignal(signal);
        }
    }
}

