/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.XMLStreamReaderUtil;
import org.activiti.bpmn.model.Process;
import org.apache.commons.lang.StringUtils;

public class PotentialStarterParser
implements BpmnXMLConstants {
    public void parse(XMLStreamReader xtr, Process activeProcess) throws Exception {
        String expression;
        String resourceElement = XMLStreamReaderUtil.moveDown(xtr);
        if (StringUtils.isNotEmpty((String)resourceElement) && "resourceAssignmentExpression".equals(resourceElement) && StringUtils.isNotEmpty((String)(expression = XMLStreamReaderUtil.moveDown(xtr))) && "formalExpression".equals(expression)) {
            List<String> assignmentList = new ArrayList<String>();
            String assignmentText = xtr.getElementText();
            if (assignmentText.contains(",")) {
                String[] assignmentArray = assignmentText.split(",");
                assignmentList = Arrays.asList(assignmentArray);
            } else {
                assignmentList.add(assignmentText);
            }
            for (String assignmentValue : assignmentList) {
                if (assignmentValue == null || (assignmentValue = assignmentValue.trim()).length() == 0) continue;
                String userPrefix = "user(";
                String groupPrefix = "group(";
                if (assignmentValue.startsWith(userPrefix)) {
                    assignmentValue = assignmentValue.substring(userPrefix.length(), assignmentValue.length() - 1).trim();
                    activeProcess.getCandidateStarterUsers().add(assignmentValue);
                    continue;
                }
                if (assignmentValue.startsWith(groupPrefix)) {
                    assignmentValue = assignmentValue.substring(groupPrefix.length(), assignmentValue.length() - 1).trim();
                    activeProcess.getCandidateStarterGroups().add(assignmentValue);
                    continue;
                }
                activeProcess.getCandidateStarterGroups().add(assignmentValue);
            }
        }
    }
}

