/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.child;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.Assignment;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.DataAssociation;
import org.apache.commons.lang.StringUtils;

public class DataAssociationParser
implements BpmnXMLConstants {
    protected static final Logger LOGGER = Logger.getLogger(DataAssociationParser.class.getName());

    public static void parseDataAssociation(DataAssociation dataAssociation, String elementName, XMLStreamReader xtr) {
        boolean readyWithDataAssociation = false;
        Assignment assignment = null;
        try {
            while (!readyWithDataAssociation && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "sourceRef".equals(xtr.getLocalName())) {
                    String sourceRef = xtr.getElementText();
                    if (!StringUtils.isNotEmpty((String)sourceRef)) continue;
                    dataAssociation.setSourceRef(sourceRef.trim());
                    continue;
                }
                if (xtr.isStartElement() && "targetRef".equals(xtr.getLocalName())) {
                    String targetRef = xtr.getElementText();
                    if (!StringUtils.isNotEmpty((String)targetRef)) continue;
                    dataAssociation.setTargetRef(targetRef.trim());
                    continue;
                }
                if (xtr.isStartElement() && "transformation".equals(xtr.getLocalName())) {
                    String transformation = xtr.getElementText();
                    if (!StringUtils.isNotEmpty((String)transformation)) continue;
                    dataAssociation.setTransformation(transformation.trim());
                    continue;
                }
                if (xtr.isStartElement() && "assignment".equals(xtr.getLocalName())) {
                    assignment = new Assignment();
                    BpmnXMLUtil.addXMLLocation((BaseElement)assignment, xtr);
                    continue;
                }
                if (xtr.isStartElement() && "from".equals(xtr.getLocalName())) {
                    String from = xtr.getElementText();
                    if (assignment == null || !StringUtils.isNotEmpty((String)from)) continue;
                    assignment.setFrom(from.trim());
                    continue;
                }
                if (xtr.isStartElement() && "to".equals(xtr.getLocalName())) {
                    String to = xtr.getElementText();
                    if (assignment == null || !StringUtils.isNotEmpty((String)to)) continue;
                    assignment.setTo(to.trim());
                    continue;
                }
                if (xtr.isEndElement() && "assignment".equals(xtr.getLocalName())) {
                    if (!StringUtils.isNotEmpty((String)assignment.getFrom()) || !StringUtils.isNotEmpty((String)assignment.getTo())) continue;
                    dataAssociation.getAssignments().add(assignment);
                    continue;
                }
                if (!xtr.isEndElement() || !elementName.equals(xtr.getLocalName())) continue;
                readyWithDataAssociation = true;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error parsing data association child elements", e);
        }
    }
}

