/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.component;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.util.StringRepresentation;
import org.apache.cocoon.sax.AbstractSAXTransformer;
import org.apache.cocoon.xml.sax.EmbeddedSAXPipe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeTransformer
extends AbstractSAXTransformer {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String INCLUDE_NS = "http://apache.org/cocoon/3.0/include";
    private static final String INCLUDE_EL = "include";
    private static final String SRC_ATTR = "src";
    private URL baseUrl;

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (!INCLUDE_NS.equals(uri) || !INCLUDE_EL.equals(localName)) {
            super.startElement(uri, localName, name, atts);
            return;
        }
        String sourceAtt = atts.getValue(SRC_ATTR);
        if (null == sourceAtt || "".equals(sourceAtt)) {
            throw new ProcessingException("The <include> element must contain a 'src' attribute that contains a URL.");
        }
        try {
            URL source = this.createSource(sourceAtt);
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            EmbeddedSAXPipe embeddedSAXPipe = new EmbeddedSAXPipe((ContentHandler)this.getSAXConsumer());
            xmlReader.setContentHandler((ContentHandler)embeddedSAXPipe);
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", embeddedSAXPipe);
            BufferedInputStream inputStream = new BufferedInputStream(source.openStream());
            xmlReader.parse(new InputSource(inputStream));
            return;
        }
        catch (IOException e) {
            throw new ProcessingException("Can't read from URL " + sourceAtt, (Throwable)e);
        }
    }

    private URL createSource(String sourceAtt) {
        try {
            URL source = null;
            source = sourceAtt.contains(":") ? new URL(sourceAtt) : new URL(this.baseUrl, sourceAtt);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Including source: " + source));
            }
            return source;
        }
        catch (MalformedURLException e) {
            throw new ProcessingException("Can't parse URL " + sourceAtt, (Throwable)e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (INCLUDE_NS.equals(uri) && INCLUDE_EL.equals(localName)) {
            return;
        }
        super.endElement(uri, localName, name);
    }

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        this.setBaseUrl((URL)configuration.get("baseUrl"));
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public String toString() {
        return StringRepresentation.buildString((Object)this, (String[])new String[]{"baseUrl=" + this.baseUrl});
    }
}

