/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricScopeInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.activiti.engine.impl.util.ClockUtil;

public class HistoricProcessInstanceEntity
extends HistoricScopeInstanceEntity
implements HistoricProcessInstance {
    private static final long serialVersionUID = 1L;
    protected String endActivityId;
    protected String businessKey;
    protected String startUserId;
    protected String startActivityId;
    protected String superProcessInstanceId;
    protected List<HistoricVariableInstanceEntity> queryVariables;

    public HistoricProcessInstanceEntity() {
    }

    public HistoricProcessInstanceEntity(ExecutionEntity processInstance) {
        this.id = processInstance.getId();
        this.processInstanceId = processInstance.getId();
        this.businessKey = processInstance.getBusinessKey();
        this.processDefinitionId = processInstance.getProcessDefinitionId();
        this.startTime = ClockUtil.getCurrentTime();
        this.startUserId = Authentication.getAuthenticatedUserId();
        this.startActivityId = processInstance.getActivityId();
        this.superProcessInstanceId = processInstance.getSuperExecution() != null ? processInstance.getSuperExecution().getProcessInstanceId() : null;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("endTime", this.endTime);
        persistentState.put("durationInMillis", this.durationInMillis);
        persistentState.put("deleteReason", this.deleteReason);
        persistentState.put("endStateName", this.endActivityId);
        persistentState.put("superProcessInstanceId", this.superProcessInstanceId);
        persistentState.put("processDefinitionId", this.processDefinitionId);
        return persistentState;
    }

    @Override
    public String getEndActivityId() {
        return this.endActivityId;
    }

    public void setEndActivityId(String endActivityId) {
        this.endActivityId = endActivityId;
    }

    @Override
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public String getStartUserId() {
        return this.startUserId;
    }

    public void setStartUserId(String startUserId) {
        this.startUserId = startUserId;
    }

    @Override
    public String getStartActivityId() {
        return this.startActivityId;
    }

    public void setStartActivityId(String startUserId) {
        this.startActivityId = startUserId;
    }

    @Override
    public String getSuperProcessInstanceId() {
        return this.superProcessInstanceId;
    }

    public void setSuperProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
    }

    @Override
    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (HistoricVariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    public List<HistoricVariableInstanceEntity> getQueryVariables() {
        return this.queryVariables;
    }

    public void setQueryVariables(List<HistoricVariableInstanceEntity> queryVariables) {
        this.queryVariables = queryVariables;
    }

    public String toString() {
        return "HistoricProcessInstanceEntity[superProcessInstanceId=" + this.superProcessInstanceId + "]";
    }
}

