/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cfg;

import java.util.ArrayList;
import java.util.Collection;
import javax.transaction.TransactionManager;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.cfg.jta.JtaTransactionContextFactory;
import org.activiti.engine.impl.interceptor.CommandContextInterceptor;
import org.activiti.engine.impl.interceptor.CommandInterceptor;
import org.activiti.engine.impl.interceptor.JtaTransactionInterceptor;
import org.activiti.engine.impl.interceptor.LogInterceptor;

public class JtaProcessEngineConfiguration
extends ProcessEngineConfigurationImpl {
    protected TransactionManager transactionManager;

    @Override
    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequired() {
        ArrayList<CommandInterceptor> defaultCommandInterceptorsTxRequired = new ArrayList<CommandInterceptor>();
        defaultCommandInterceptorsTxRequired.add(new LogInterceptor());
        defaultCommandInterceptorsTxRequired.add(new JtaTransactionInterceptor(this.transactionManager, false));
        defaultCommandInterceptorsTxRequired.add(new CommandContextInterceptor(this.commandContextFactory, this));
        return defaultCommandInterceptorsTxRequired;
    }

    @Override
    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequiresNew() {
        ArrayList<CommandInterceptor> defaultCommandInterceptorsTxRequiresNew = new ArrayList<CommandInterceptor>();
        defaultCommandInterceptorsTxRequiresNew.add(new LogInterceptor());
        defaultCommandInterceptorsTxRequiresNew.add(new JtaTransactionInterceptor(this.transactionManager, true));
        defaultCommandInterceptorsTxRequiresNew.add(new CommandContextInterceptor(this.commandContextFactory, this));
        return defaultCommandInterceptorsTxRequiresNew;
    }

    @Override
    protected void initTransactionContextFactory() {
        if (this.transactionContextFactory == null) {
            this.transactionContextFactory = new JtaTransactionContextFactory(this.transactionManager);
        }
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

