/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.form.upload;

import java.util.Formatter;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IInitializer;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadStatusResource;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.SharedResourceReference;
import org.apache.wicket.resource.CoreLibrariesContributor;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadProgressBar
extends Panel {
    private static final Logger log = LoggerFactory.getLogger(UploadProgressBar.class);
    public static final String RESOURCE_STARTING = "UploadProgressBar.starting";
    private static final ResourceReference JS = new JavaScriptResourceReference(UploadProgressBar.class, "progressbar.js");
    private static final ResourceReference CSS = new CssResourceReference(UploadProgressBar.class, "UploadProgressBar.css");
    private static final String RESOURCE_NAME = UploadProgressBar.class.getName();
    private static final long serialVersionUID = 1L;
    private final Form<?> form;
    private final WebMarkupContainer statusDiv;
    private final WebMarkupContainer barDiv;
    private final FileUploadField uploadField;

    public UploadProgressBar(String id, Form<?> form) {
        this(id, form, null);
    }

    public UploadProgressBar(String id, Form<?> form, FileUploadField uploadField) {
        super(id);
        this.uploadField = uploadField;
        if (uploadField != null) {
            uploadField.setOutputMarkupId(true);
        }
        this.form = form;
        form.setOutputMarkupId(true);
        this.setRenderBodyOnly(true);
        this.barDiv = new WebMarkupContainer("bar");
        this.barDiv.setOutputMarkupId(true);
        this.add(new Component[]{this.barDiv});
        this.statusDiv = new WebMarkupContainer("status");
        this.statusDiv.setOutputMarkupId(true);
        this.add(new Component[]{this.statusDiv});
    }

    protected void onInitialize() {
        super.onInitialize();
        this.getCallbackForm().setOutputMarkupId(true);
    }

    protected ResourceReference getCss() {
        return CSS;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        CoreLibrariesContributor.contributeAjax((Application)this.getApplication(), (IHeaderResponse)response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JS));
        ResourceReference css = this.getCss();
        if (css != null) {
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)css));
        }
        SharedResourceReference ref = new SharedResourceReference(RESOURCE_NAME);
        String uploadFieldId = this.uploadField == null ? "" : this.uploadField.getMarkupId();
        String status = new StringResourceModel(RESOURCE_STARTING, (Component)this, (IModel)null, new Object[0]).getString();
        CharSequence url = this.urlFor((ResourceReference)ref, UploadStatusResource.newParameter(this.getPage().getId()));
        StringBuilder builder = new StringBuilder(128);
        Formatter formatter = new Formatter(builder);
        formatter.format("new Wicket.WUPB('%s', '%s', '%s', '%s', '%s', '%s');", this.getCallbackForm().getMarkupId(), this.statusDiv.getMarkupId(), this.barDiv.getMarkupId(), url, uploadFieldId, status);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)builder.toString()));
    }

    private Form<?> getCallbackForm() {
        Boolean insideModal = (Boolean)this.form.visitParents(ModalWindow.class, (IVisitor)new IVisitor<ModalWindow, Boolean>(){

            public void component(ModalWindow object, IVisit<Boolean> visit) {
                visit.stop((Object)true);
            }
        });
        if (insideModal != null && insideModal.booleanValue()) {
            return this.form;
        }
        return this.form.getRootForm();
    }

    public static final class ComponentInitializer
    implements IInitializer {
        public void init(Application application) {
            Application.get().getSharedResources().add(RESOURCE_NAME, (IResource)new UploadStatusResource());
        }

        public String toString() {
            return "UploadProgressBar initializer";
        }

        public void destroy(Application application) {
        }
    }
}

