/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.HashMap;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;

public final class SyncDelta {
    private final SyncToken _token;
    private final SyncDeltaType _deltaType;
    private final Uid _previousUid;
    private final Uid _uid;
    private final ConnectorObject _object;

    SyncDelta(SyncToken token, SyncDeltaType deltaType, Uid previousUid, Uid uid, ConnectorObject object) {
        Assertions.nullCheck(token, "token");
        Assertions.nullCheck((Object)deltaType, "deltaType");
        Assertions.nullCheck(uid, "uid");
        if (previousUid != null && deltaType != SyncDeltaType.CREATE_OR_UPDATE) {
            throw new IllegalArgumentException("The previous Uid can only be specified for create or update.");
        }
        if (object == null && deltaType != SyncDeltaType.DELETE) {
            throw new IllegalArgumentException("ConnectorObject must be specified for anything other than delete.");
        }
        if (object != null && !uid.equals(object.getUid())) {
            throw new IllegalArgumentException("Uid does not match that of the object.");
        }
        this._token = token;
        this._deltaType = deltaType;
        this._previousUid = previousUid;
        this._uid = uid;
        this._object = object;
    }

    public Uid getPreviousUid() {
        return this._previousUid;
    }

    public Uid getUid() {
        return this._uid;
    }

    public ConnectorObject getObject() {
        return this._object;
    }

    public SyncToken getToken() {
        return this._token;
    }

    public SyncDeltaType getDeltaType() {
        return this._deltaType;
    }

    public String toString() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("Token", this._token);
        values.put("DeltaType", (Object)this._deltaType);
        values.put("PreviousUid", this._previousUid);
        values.put("Uid", this._uid);
        values.put("Object", this._object);
        return ((Object)values).toString();
    }

    public int hashCode() {
        return this._uid.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SyncDelta) {
            SyncDelta other = (SyncDelta)o;
            if (!this._token.equals(other._token)) {
                return false;
            }
            if (!this._deltaType.equals((Object)other._deltaType)) {
                return false;
            }
            if (this._previousUid == null ? other._previousUid != null : !this._previousUid.equals(other._previousUid)) {
                return false;
            }
            if (!this._uid.equals(other._uid)) {
                return false;
            }
            return !(this._object == null ? other._object != null : !this._object.equals(other._object));
        }
        return false;
    }
}

