/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.validation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.syncope.common.types.SyncopeClientExceptionType;
import org.apache.syncope.common.validation.SyncopeClientException;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpClientErrorException;

public class SyncopeClientCompositeErrorException
extends HttpClientErrorException {
    private static final long serialVersionUID = 7882118041134372129L;
    private Set<SyncopeClientException> exceptions = new HashSet<SyncopeClientException>();

    public SyncopeClientCompositeErrorException(HttpStatus statusCode) {
        super(statusCode);
    }

    public boolean hasExceptions() {
        return !this.exceptions.isEmpty();
    }

    public boolean hasException(SyncopeClientExceptionType exceptionType) {
        return this.getException(exceptionType) != null;
    }

    public SyncopeClientException getException(SyncopeClientExceptionType exceptionType) {
        boolean found = false;
        SyncopeClientException syncopeClientException = null;
        Iterator<SyncopeClientException> itor = this.exceptions.iterator();
        while (itor.hasNext() && !found) {
            syncopeClientException = itor.next();
            if (!syncopeClientException.getType().equals((Object)exceptionType)) continue;
            found = true;
        }
        return found ? syncopeClientException : null;
    }

    public Set<SyncopeClientException> getExceptions() {
        return this.exceptions;
    }

    public boolean addException(SyncopeClientException exception) {
        if (exception.getType() == null) {
            throw new IllegalArgumentException(exception + " does not have the right " + SyncopeClientExceptionType.class.getName() + " set");
        }
        return this.exceptions.add(exception);
    }

    public String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append("{");
        Iterator<SyncopeClientException> iter = this.getExceptions().iterator();
        while (iter.hasNext()) {
            SyncopeClientException e = iter.next();
            message.append("[");
            message.append((Object)e.getType());
            message.append(" ");
            message.append(e.getElements());
            message.append("]");
            if (!iter.hasNext()) continue;
            message.append(", ");
        }
        message.append("}");
        return message.toString();
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }
}

