/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.page;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.wicket.page.AbstractPageManager;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.page.IPageManagerContext;
import org.apache.wicket.page.RequestAdapter;
import org.apache.wicket.pageStore.IPageStore;

public class PageStoreManager
extends AbstractPageManager {
    private static final ConcurrentMap<String, PageStoreManager> managers = new ConcurrentHashMap<String, PageStoreManager>();
    private final IPageStore pageStore;
    private final String applicationName;

    public PageStoreManager(String applicationName, IPageStore pageStore, IPageManagerContext context) {
        super(context);
        this.applicationName = applicationName;
        this.pageStore = pageStore;
        if (managers.containsKey(applicationName)) {
            throw new IllegalStateException("Manager for application with key '" + applicationName + "' already exists.");
        }
        managers.put(applicationName, this);
    }

    @Override
    protected RequestAdapter newRequestAdapter(IPageManagerContext context) {
        return new PersistentRequestAdapter(context);
    }

    @Override
    public boolean supportsVersioning() {
        return true;
    }

    @Override
    public void sessionExpired(String sessionId) {
    }

    @Override
    public void destroy() {
        managers.remove(this.applicationName);
        this.pageStore.destroy();
    }

    protected class PersistentRequestAdapter
    extends RequestAdapter {
        private static final String ATTRIBUTE_NAME = "wicket:persistentPageManagerData";

        private String getAttributeName() {
            return "wicket:persistentPageManagerData - " + PageStoreManager.this.applicationName;
        }

        public PersistentRequestAdapter(IPageManagerContext context) {
            super(context);
        }

        @Override
        protected IManageablePage getPage(int id) {
            IManageablePage touchedPage = this.findPage(id);
            if (touchedPage != null) {
                return touchedPage;
            }
            SessionEntry entry = this.getSessionEntry(false);
            if (entry != null) {
                return entry.getPage(id);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SessionEntry getSessionEntry(boolean create) {
            SessionEntry entry = (SessionEntry)this.getSessionAttribute(this.getAttributeName());
            if (entry == null && create) {
                this.bind();
                entry = new SessionEntry(PageStoreManager.this.applicationName, this.getSessionId());
            }
            if (entry != null) {
                SessionEntry sessionEntry = entry;
                synchronized (sessionEntry) {
                    this.setSessionAttribute(this.getAttributeName(), entry);
                }
            }
            return entry;
        }

        @Override
        protected void newSessionCreated() {
            if (this.getSessionId() != null) {
                this.getSessionEntry(true);
            }
        }

        @Override
        protected void storeTouchedPages(List<IManageablePage> touchedPages) {
            if (!touchedPages.isEmpty()) {
                SessionEntry entry = this.getSessionEntry(true);
                entry.setSessionCache(touchedPages);
                for (IManageablePage page : touchedPages) {
                    PageStoreManager.this.pageStore.storePage(entry.sessionId, page);
                }
            }
        }
    }

    private static class SessionEntry
    implements Serializable,
    HttpSessionBindingListener {
        private static final long serialVersionUID = 1L;
        private final String applicationName;
        private final String sessionId;
        private transient List<IManageablePage> sessionCache;
        private transient List<Object> afterReadObject;

        public SessionEntry(String applicationName, String sessionId) {
            this.applicationName = applicationName;
            this.sessionId = sessionId;
        }

        private IPageStore getPageStore() {
            PageStoreManager manager = (PageStoreManager)managers.get(this.applicationName);
            if (manager == null) {
                return null;
            }
            return manager.pageStore;
        }

        private IManageablePage findPage(int id) {
            for (IManageablePage p : this.sessionCache) {
                if (p.getPageId() != id) continue;
                return p;
            }
            return null;
        }

        private void addPage(IManageablePage page) {
            if (page != null) {
                if (this.findPage(page.getPageId()) != null) {
                    return;
                }
                this.sessionCache.add(page);
            }
        }

        private void convertAfterReadObjects() {
            if (this.sessionCache == null) {
                this.sessionCache = new ArrayList<IManageablePage>();
            }
            for (Object o : this.afterReadObject) {
                IManageablePage page = this.getPageStore().convertToPage(o);
                this.addPage(page);
            }
            this.afterReadObject = null;
        }

        public synchronized IManageablePage getPage(int id) {
            IManageablePage page;
            if (this.afterReadObject != null && !this.afterReadObject.isEmpty()) {
                this.convertAfterReadObjects();
            }
            if (this.sessionCache != null && (page = this.findPage(id)) != null) {
                return page;
            }
            return this.getPageStore().getPage(this.sessionId, id);
        }

        public synchronized void setSessionCache(List<IManageablePage> pages) {
            this.sessionCache = new ArrayList<IManageablePage>(pages);
            this.afterReadObject = null;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            ArrayList<Object> serializedPages = new ArrayList<Object>();
            if (this.sessionCache != null) {
                IPageStore pageStore = this.getPageStore();
                for (IManageablePage p : this.sessionCache) {
                    Object preparedPage = pageStore != null ? pageStore.prepareForSerialization(this.sessionId, p) : p;
                    if (preparedPage == null) continue;
                    serializedPages.add(preparedPage);
                }
            }
            s.writeObject(serializedPages);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.afterReadObject = new ArrayList<Object>();
            List l = (List)s.readObject();
            IPageStore pageStore = this.getPageStore();
            for (Serializable ser : l) {
                Object page = pageStore != null ? pageStore.restoreAfterSerialization(ser) : ser;
                this.afterReadObject.add(page);
            }
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            IPageStore store = this.getPageStore();
            if (store != null) {
                store.unbind(this.sessionId);
            }
        }
    }
}

