/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.services.proxy;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.services.proxy.SpringServiceProxy;
import org.apache.syncope.common.services.ResourceService;
import org.apache.syncope.common.to.BulkAction;
import org.apache.syncope.common.to.BulkActionRes;
import org.apache.syncope.common.to.ConnObjectTO;
import org.apache.syncope.common.to.PropagationActionClassTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.common.util.CollectionWrapper;
import org.springframework.web.client.RestTemplate;

public class ResourceServiceProxy
extends SpringServiceProxy
implements ResourceService {
    public ResourceServiceProxy(String baseUrl, RestTemplate restTemplate) {
        super(baseUrl, restTemplate);
    }

    public Response create(ResourceTO resourceTO) {
        ResourceTO resource = (ResourceTO)this.getRestTemplate().postForObject(this.baseUrl + "resource/create.json", (Object)resourceTO, ResourceTO.class, new Object[0]);
        try {
            URI location = URI.create(this.baseUrl + "resource/read/" + URLEncoder.encode(resource.getName(), "UTF-8") + ".json");
            return Response.created((URI)location).header("org.apache.syncope.resource.id", (Object)resource.getName()).build();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public void update(String resourceName, ResourceTO resourceTO) {
        this.getRestTemplate().postForObject(this.baseUrl + "resource/update.json", (Object)resourceTO, ResourceTO.class, new Object[0]);
    }

    public void delete(String resourceName) {
        this.getRestTemplate().getForObject(this.baseUrl + "resource/delete/{resourceName}.json", ResourceTO.class, new Object[]{resourceName});
    }

    public ResourceTO read(String resourceName) {
        return (ResourceTO)this.getRestTemplate().getForObject(this.baseUrl + "resource/read/{resourceName}.json", ResourceTO.class, new Object[]{resourceName});
    }

    public Set<PropagationActionClassTO> getPropagationActionsClasses() {
        return CollectionWrapper.wrapPropagationActionClasses(this.handlePossiblyEmptyStringCollection(this.baseUrl + "resource/propagationActionsClasses.json"));
    }

    public List<ResourceTO> list() {
        return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "resource/list.json", ResourceTO[].class, new Object[0]));
    }

    public List<ResourceTO> list(Long connInstanceId) {
        return connInstanceId == null ? this.list() : Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "resource/list.json?connInstanceId={connId}", ResourceTO[].class, new Object[]{connInstanceId}));
    }

    public ConnObjectTO getConnectorObject(String resourceName, AttributableType type, Long id) {
        return (ConnObjectTO)this.getRestTemplate().getForObject(this.baseUrl + "resource/{resourceName}/read/{type}/{id}.json", ConnObjectTO.class, new Object[]{resourceName, type.name(), id});
    }

    public boolean check(ResourceTO resourceTO) {
        return (Boolean)this.getRestTemplate().postForObject(this.baseUrl + "resource/check.json", (Object)resourceTO, Boolean.class, new Object[0]);
    }

    public BulkActionRes bulkAction(BulkAction bulkAction) {
        return (BulkActionRes)this.getRestTemplate().postForObject(this.baseUrl + "resource/bulk", (Object)bulkAction, BulkActionRes.class, new Object[0]);
    }
}

