/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.lang.annotation.ElementType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.apache.bval.util.AccessStrategy;
import org.apache.commons.lang3.reflect.TypeUtils;

public class KeyedAccess
extends AccessStrategy {
    private static final TypeVariable<?>[] MAP_TYPEVARS = Map.class.getTypeParameters();
    private Type containerType;
    private Object key;

    public static Type getJavaElementType(Type containerType) {
        if (TypeUtils.isAssignable((Type)containerType, Map.class)) {
            Map typeArguments = TypeUtils.getTypeArguments((Type)containerType, Map.class);
            return typeArguments.containsKey(MAP_TYPEVARS[1]) ? (Type)typeArguments.get(MAP_TYPEVARS[1]) : Object.class;
        }
        return null;
    }

    public KeyedAccess(Type containerType, Object key) {
        this.containerType = containerType;
        this.key = key;
    }

    public Object get(Object instance) {
        if (instance instanceof Map) {
            Map map = (Map)instance;
            Map typeArguments = TypeUtils.getTypeArguments((Type)this.containerType, Map.class);
            Type keyType = (Type)typeArguments.get(MAP_TYPEVARS[0]);
            if (this.key == null || keyType == null || TypeUtils.isInstance((Object)this.key, (Type)keyType)) {
                return map.get(this.key);
            }
            if (this.key instanceof String) {
                String name = (String)this.key;
                Class rawKeyType = TypeUtils.getRawType((Type)keyType, (Type)this.containerType);
                if (rawKeyType.isEnum()) {
                    Object result = map.get(Enum.valueOf(rawKeyType, name));
                    return result;
                }
                for (Map.Entry e : map.entrySet()) {
                    if (!name.equals(e.getKey())) continue;
                    return e.getValue();
                }
            }
        }
        return null;
    }

    public ElementType getElementType() {
        return ElementType.METHOD;
    }

    public Type getJavaType() {
        Type result = KeyedAccess.getJavaElementType(this.containerType);
        return result == null ? Object.class : result;
    }

    public String getPropertyName() {
        return String.format("[%s]", this.key);
    }
}

