/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.services;

import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.services.ReportletConfClasses;
import org.apache.syncope.common.to.ReportExecTO;
import org.apache.syncope.common.to.ReportTO;
import org.apache.syncope.common.types.ReportExecExportFormat;

@Path(value="reports")
public interface ReportService {
    @GET
    @Path(value="count")
    public int count();

    @POST
    public Response create(ReportTO var1);

    @DELETE
    @Path(value="{reportId}")
    public void delete(@PathParam(value="reportId") Long var1);

    @DELETE
    @Path(value="executions/{executionId}")
    public void deleteExecution(@PathParam(value="executionId") Long var1);

    @POST
    @Path(value="{reportId}/execute")
    public ReportExecTO execute(@PathParam(value="reportId") Long var1);

    @GET
    @Path(value="executions/{executionId}/stream")
    public Response exportExecutionResult(@PathParam(value="executionId") Long var1, @QueryParam(value="format") ReportExecExportFormat var2);

    @GET
    @Path(value="reportletConfClasses")
    public ReportletConfClasses getReportletConfClasses();

    @GET
    public List<ReportTO> list();

    @GET
    public List<ReportTO> list(@QueryParam(value="page") int var1, @QueryParam(value="size") @DefaultValue(value="25") int var2);

    @GET
    @Path(value="{reportId}")
    public ReportTO read(@PathParam(value="reportId") Long var1);

    @GET
    @Path(value="executions/{executionId}")
    public ReportExecTO readExecution(@PathParam(value="executionId") Long var1);

    @PUT
    @Path(value="{reportId}")
    public void update(@PathParam(value="reportId") Long var1, ReportTO var2);
}

