/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.sort;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class OrderByLink<S>
extends Link<Void> {
    private static final long serialVersionUID = 1L;
    private final S property;
    private final ISortStateLocator<S> stateLocator;

    public OrderByLink(String id, S sortProperty, ISortStateLocator<S> stateLocator) {
        this(id, sortProperty, stateLocator, new DefaultCssProvider());
    }

    public OrderByLink(String id, S property, ISortStateLocator<S> stateLocator, ICssProvider<S> cssProvider) {
        super(id);
        Args.notNull(cssProvider, (String)"cssProvider");
        Args.notNull(property, (String)"property");
        this.property = property;
        this.stateLocator = stateLocator;
        this.add(new Behavior[]{new CssModifier<S>(this, cssProvider)});
    }

    public final void onClick() {
        this.sort();
        this.onSortChanged();
    }

    protected void onSortChanged() {
    }

    public final OrderByLink<S> sort() {
        if (this.isVersioned()) {
            this.addStateChange();
        }
        ISortState<S> state = this.stateLocator.getSortState();
        SortOrder order = state.getPropertySortOrder(this.property);
        state.setPropertySortOrder(this.property, this.nextSortOrder(order));
        return this;
    }

    protected SortOrder nextSortOrder(SortOrder order) {
        if (order == SortOrder.NONE) {
            return SortOrder.ASCENDING;
        }
        return order == SortOrder.ASCENDING ? SortOrder.DESCENDING : SortOrder.ASCENDING;
    }

    public static class DefaultCssProvider<S>
    extends CssProvider<S> {
        private static final long serialVersionUID = 1L;

        public DefaultCssProvider() {
            super("wicket_orderUp", "wicket_orderDown", "wicket_orderNone");
        }
    }

    public static class VoidCssProvider<S>
    extends CssProvider<S> {
        private static final long serialVersionUID = 1L;

        public VoidCssProvider() {
            super("", "", "");
        }
    }

    public static class CssProvider<S>
    implements ICssProvider<S> {
        private static final long serialVersionUID = 1L;
        private final String ascending;
        private final String descending;
        private final String none;

        public CssProvider(String ascending, String descending, String none) {
            this.ascending = ascending;
            this.descending = descending;
            this.none = none;
        }

        @Override
        public String getClassAttributeValue(ISortState<S> state, S sortProperty) {
            SortOrder dir = state.getPropertySortOrder(sortProperty);
            if (dir == SortOrder.ASCENDING) {
                return this.ascending;
            }
            if (dir == SortOrder.DESCENDING) {
                return this.descending;
            }
            return this.none;
        }
    }

    public static interface ICssProvider<S>
    extends IClusterable {
        public String getClassAttributeValue(ISortState<S> var1, S var2);
    }

    public static class CssModifier<S>
    extends Behavior {
        private static final long serialVersionUID = 1L;
        private final OrderByLink<S> link;
        private final ICssProvider<S> provider;

        public CssModifier(OrderByLink<S> link, ICssProvider<S> provider) {
            this.link = link;
            this.provider = provider;
        }

        public void onComponentTag(Component component, ComponentTag tag) {
            super.onComponentTag(component, tag);
            ISortState sortState = ((OrderByLink)this.link).stateLocator.getSortState();
            String cssClass = this.provider.getClassAttributeValue(sortState, ((OrderByLink)this.link).property);
            if (!Strings.isEmpty((CharSequence)cssClass)) {
                tag.append("class", (CharSequence)cssClass, " ");
            }
        }
    }
}

