/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.parser;

import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ItemDefinition;
import org.apache.commons.lang.StringUtils;

public class ItemDefinitionParser
implements BpmnXMLConstants {
    public void parse(XMLStreamReader xtr, BpmnModel model) throws Exception {
        if (StringUtils.isNotEmpty((String)xtr.getAttributeValue(null, "id"))) {
            String itemDefinitionId = model.getTargetNamespace() + ":" + xtr.getAttributeValue(null, "id");
            String structureRef = xtr.getAttributeValue(null, "structureRef");
            if (StringUtils.isNotEmpty((String)structureRef)) {
                ItemDefinition item = new ItemDefinition();
                item.setId(itemDefinitionId);
                BpmnXMLUtil.addXMLLocation((BaseElement)item, xtr);
                int indexOfP = structureRef.indexOf(58);
                if (indexOfP != -1) {
                    String prefix = structureRef.substring(0, indexOfP);
                    String resolvedNamespace = model.getNamespace(prefix);
                    structureRef = resolvedNamespace + ":" + structureRef.substring(indexOfP + 1);
                } else {
                    structureRef = model.getTargetNamespace() + ":" + structureRef;
                }
                item.setStructureRef(structureRef);
                item.setItemKind(xtr.getAttributeValue(null, "itemKind"));
                model.addItemDefinition(itemDefinitionId, item);
            }
        }
    }
}

