/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.AssociationXMLConverter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.BoundaryEventXMLConverter;
import org.activiti.bpmn.converter.BusinessRuleTaskXMLConverter;
import org.activiti.bpmn.converter.CallActivityXMLConverter;
import org.activiti.bpmn.converter.CatchEventXMLConverter;
import org.activiti.bpmn.converter.EndEventXMLConverter;
import org.activiti.bpmn.converter.EventGatewayXMLConverter;
import org.activiti.bpmn.converter.ExclusiveGatewayXMLConverter;
import org.activiti.bpmn.converter.InclusiveGatewayXMLConverter;
import org.activiti.bpmn.converter.IndentingXMLStreamWriter;
import org.activiti.bpmn.converter.ManualTaskXMLConverter;
import org.activiti.bpmn.converter.ParallelGatewayXMLConverter;
import org.activiti.bpmn.converter.ReceiveTaskXMLConverter;
import org.activiti.bpmn.converter.ScriptTaskXMLConverter;
import org.activiti.bpmn.converter.SendTaskXMLConverter;
import org.activiti.bpmn.converter.SequenceFlowXMLConverter;
import org.activiti.bpmn.converter.ServiceTaskXMLConverter;
import org.activiti.bpmn.converter.StartEventXMLConverter;
import org.activiti.bpmn.converter.TaskXMLConverter;
import org.activiti.bpmn.converter.TextAnnotationXMLConverter;
import org.activiti.bpmn.converter.ThrowEventXMLConverter;
import org.activiti.bpmn.converter.UserTaskXMLConverter;
import org.activiti.bpmn.converter.alfresco.AlfrescoStartEventXMLConverter;
import org.activiti.bpmn.converter.alfresco.AlfrescoUserTaskXMLConverter;
import org.activiti.bpmn.converter.child.DocumentationParser;
import org.activiti.bpmn.converter.child.ExecutionListenerParser;
import org.activiti.bpmn.converter.child.IOSpecificationParser;
import org.activiti.bpmn.converter.child.MultiInstanceParser;
import org.activiti.bpmn.converter.export.ActivitiListenerExport;
import org.activiti.bpmn.converter.export.BPMNDIExport;
import org.activiti.bpmn.converter.export.DefinitionsRootExport;
import org.activiti.bpmn.converter.export.MultiInstanceExport;
import org.activiti.bpmn.converter.export.PoolExport;
import org.activiti.bpmn.converter.export.ProcessExport;
import org.activiti.bpmn.converter.export.SignalAndMessageDefinitionExport;
import org.activiti.bpmn.converter.parser.BpmnEdgeParser;
import org.activiti.bpmn.converter.parser.BpmnShapeParser;
import org.activiti.bpmn.converter.parser.ImportParser;
import org.activiti.bpmn.converter.parser.InterfaceParser;
import org.activiti.bpmn.converter.parser.ItemDefinitionParser;
import org.activiti.bpmn.converter.parser.LaneParser;
import org.activiti.bpmn.converter.parser.MessageParser;
import org.activiti.bpmn.converter.parser.PotentialStarterParser;
import org.activiti.bpmn.converter.parser.ProcessParser;
import org.activiti.bpmn.converter.parser.SignalParser;
import org.activiti.bpmn.converter.parser.SubProcessParser;
import org.activiti.bpmn.converter.util.InputStreamProvider;
import org.activiti.bpmn.exceptions.XMLException;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Pool;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SubProcess;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class BpmnXMLConverter
implements BpmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BpmnXMLConverter.class);
    protected static final String BPMN_XSD = "org/activiti/impl/bpmn/parser/BPMN20.xsd";
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected static Map<String, Class<? extends BaseBpmnXMLConverter>> convertersToBpmnMap = new HashMap<String, Class<? extends BaseBpmnXMLConverter>>();
    protected static Map<Class<? extends BaseElement>, Class<? extends BaseBpmnXMLConverter>> convertersToXMLMap = new HashMap<Class<? extends BaseElement>, Class<? extends BaseBpmnXMLConverter>>();
    protected ClassLoader classloader;
    protected List<String> userTaskFormTypes;
    protected List<String> startEventFormTypes;

    private static void addConverter(String elementName, Class<? extends BaseElement> elementClass, Class<? extends BaseBpmnXMLConverter> converter) {
        convertersToBpmnMap.put(elementName, converter);
        convertersToXMLMap.put(elementClass, converter);
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public void setUserTaskFormTypes(List<String> userTaskFormTypes) {
        this.userTaskFormTypes = userTaskFormTypes;
    }

    public void setStartEventFormTypes(List<String> startEventFormTypes) {
        this.startEventFormTypes = startEventFormTypes;
    }

    public void validateModel(InputStreamProvider inputStreamProvider) throws Exception {
        Schema schema = this.createSchema();
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(inputStreamProvider.getInputStream()));
    }

    public void validateModel(XMLStreamReader xmlStreamReader) throws Exception {
        Schema schema = this.createSchema();
        Validator validator = schema.newValidator();
        validator.validate(new StAXSource(xmlStreamReader));
    }

    protected Schema createSchema() throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        if (this.classloader != null) {
            schema = factory.newSchema(this.classloader.getResource(BPMN_XSD));
        }
        if (schema == null) {
            schema = factory.newSchema(BpmnXMLConverter.class.getClassLoader().getResource(BPMN_XSD));
        }
        if (schema == null) {
            throw new XMLException("BPMN XSD could not be found");
        }
        return schema;
    }

    public BpmnModel convertToBpmnModel(InputStreamProvider inputStreamProvider, boolean validateSchema, boolean enableSafeBpmnXml) {
        return this.convertToBpmnModel(inputStreamProvider, validateSchema, enableSafeBpmnXml, DEFAULT_ENCODING);
    }

    public BpmnModel convertToBpmnModel(InputStreamProvider inputStreamProvider, boolean validateSchema, boolean enableSafeBpmnXml, String encoding) {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        if (xif.isPropertySupported("javax.xml.stream.isReplacingEntityReferences")) {
            xif.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        }
        if (xif.isPropertySupported("javax.xml.stream.isSupportingExternalEntities")) {
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        if (xif.isPropertySupported("javax.xml.stream.supportDTD")) {
            xif.setProperty("javax.xml.stream.supportDTD", false);
        }
        InputStreamReader in = null;
        try {
            in = new InputStreamReader(inputStreamProvider.getInputStream(), encoding);
            XMLStreamReader xtr = xif.createXMLStreamReader(in);
            try {
                if (validateSchema) {
                    if (!enableSafeBpmnXml) {
                        this.validateModel(inputStreamProvider);
                    } else {
                        this.validateModel(xtr);
                    }
                    in = new InputStreamReader(inputStreamProvider.getInputStream(), encoding);
                    xtr = xif.createXMLStreamReader(in);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not validate XML with BPMN 2.0 XSD", e);
            }
            BpmnModel bpmnModel = this.convertToBpmnModel(xtr);
            return bpmnModel;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("The bpmn 2.0 xml is not UTF8 encoded", e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Error while reading the BPMN 2.0 XML", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.info("Problem closing BPMN input stream", (Throwable)e);
                }
            }
        }
    }

    public BpmnModel convertToBpmnModel(XMLStreamReader xtr) {
        BpmnModel model = new BpmnModel();
        try {
            Process activeProcess = null;
            ArrayList<SubProcess> activeSubProcessList = new ArrayList<SubProcess>();
            while (xtr.hasNext()) {
                try {
                    xtr.next();
                }
                catch (Exception e) {
                    LOGGER.error("Error reading XML document", (Throwable)e);
                    throw new XMLException("Error reading XML", e);
                }
                if (xtr.isEndElement() && "subProcess".equals(xtr.getLocalName())) {
                    activeSubProcessList.remove(activeSubProcessList.size() - 1);
                }
                if (xtr.isEndElement() && "transaction".equals(xtr.getLocalName())) {
                    activeSubProcessList.remove(activeSubProcessList.size() - 1);
                }
                if (!xtr.isStartElement()) continue;
                if ("definitions".equals(xtr.getLocalName())) {
                    model.setTargetNamespace(xtr.getAttributeValue(null, "targetNamespace"));
                    for (int i = 0; i < xtr.getNamespaceCount(); ++i) {
                        String prefix = xtr.getNamespacePrefix(i);
                        if (prefix == null) continue;
                        model.addNamespace(prefix, xtr.getNamespaceURI(i));
                    }
                    continue;
                }
                if ("signal".equals(xtr.getLocalName())) {
                    new SignalParser().parse(xtr, model);
                    continue;
                }
                if ("message".equals(xtr.getLocalName())) {
                    new MessageParser().parse(xtr, model);
                    continue;
                }
                if ("error".equals(xtr.getLocalName())) {
                    if (!StringUtils.isNotEmpty((String)xtr.getAttributeValue(null, "id"))) continue;
                    model.addError(xtr.getAttributeValue(null, "id"), xtr.getAttributeValue(null, "errorCode"));
                    continue;
                }
                if ("import".equals(xtr.getLocalName())) {
                    new ImportParser().parse(xtr, model);
                    continue;
                }
                if ("itemDefinition".equals(xtr.getLocalName())) {
                    new ItemDefinitionParser().parse(xtr, model);
                    continue;
                }
                if ("interface".equals(xtr.getLocalName())) {
                    new InterfaceParser().parse(xtr, model);
                    continue;
                }
                if ("ioSpecification".equals(xtr.getLocalName())) {
                    new IOSpecificationParser().parseChildElement(xtr, (BaseElement)activeProcess, model);
                    continue;
                }
                if ("participant".equals(xtr.getLocalName())) {
                    if (!StringUtils.isNotEmpty((String)xtr.getAttributeValue(null, "id"))) continue;
                    Pool pool = new Pool();
                    pool.setId(xtr.getAttributeValue(null, "id"));
                    pool.setName(xtr.getAttributeValue(null, "name"));
                    pool.setProcessRef(xtr.getAttributeValue(null, "processRef"));
                    model.getPools().add(pool);
                    continue;
                }
                if ("process".equals(xtr.getLocalName())) {
                    Process process = new ProcessParser().parse(xtr, model);
                    if (process == null) continue;
                    activeProcess = process;
                    continue;
                }
                if ("potentialStarter".equals(xtr.getLocalName())) {
                    new PotentialStarterParser().parse(xtr, activeProcess);
                    continue;
                }
                if ("lane".equals(xtr.getLocalName())) {
                    new LaneParser().parse(xtr, activeProcess);
                    continue;
                }
                if ("documentation".equals(xtr.getLocalName())) {
                    Process parentElement = null;
                    if (activeSubProcessList.size() > 0) {
                        parentElement = (BaseElement)activeSubProcessList.get(activeSubProcessList.size() - 1);
                    } else if (activeProcess != null) {
                        parentElement = activeProcess;
                    }
                    new DocumentationParser().parseChildElement(xtr, (BaseElement)parentElement, model);
                    continue;
                }
                if ("subProcess".equals(xtr.getLocalName())) {
                    new SubProcessParser().parse(xtr, activeSubProcessList, activeProcess);
                    continue;
                }
                if ("transaction".equals(xtr.getLocalName())) {
                    new SubProcessParser().parse(xtr, activeSubProcessList, activeProcess);
                    continue;
                }
                if ("BPMNShape".equals(xtr.getLocalName())) {
                    new BpmnShapeParser().parse(xtr, model);
                    continue;
                }
                if ("BPMNEdge".equals(xtr.getLocalName())) {
                    new BpmnEdgeParser().parse(xtr, model);
                    continue;
                }
                if (activeSubProcessList.size() == 0 && "executionListener".equals(xtr.getLocalName())) {
                    new ExecutionListenerParser().parseChildElement(xtr, (BaseElement)activeProcess, model);
                    continue;
                }
                if (activeSubProcessList.size() > 0 && "executionListener".equalsIgnoreCase(xtr.getLocalName())) {
                    new ExecutionListenerParser().parseChildElement(xtr, (BaseElement)activeSubProcessList.get(activeSubProcessList.size() - 1), model);
                    continue;
                }
                if (activeSubProcessList.size() > 0 && "multiInstanceLoopCharacteristics".equalsIgnoreCase(xtr.getLocalName())) {
                    new MultiInstanceParser().parseChildElement(xtr, (BaseElement)activeSubProcessList.get(activeSubProcessList.size() - 1), model);
                    continue;
                }
                if (!convertersToBpmnMap.containsKey(xtr.getLocalName()) || activeProcess == null || !activeProcess.isExecutable()) continue;
                Class<? extends BaseBpmnXMLConverter> converterClass = convertersToBpmnMap.get(xtr.getLocalName());
                BaseBpmnXMLConverter converter = converterClass.newInstance();
                if (this.userTaskFormTypes != null && "userTask".equals(xtr.getLocalName())) {
                    UserTaskXMLConverter userTaskConverter = (UserTaskXMLConverter)converter;
                    for (String formType : this.userTaskFormTypes) {
                        userTaskConverter.addFormType(formType);
                    }
                } else if (this.startEventFormTypes != null && "startEvent".equals(xtr.getLocalName())) {
                    StartEventXMLConverter startEventConverter = (StartEventXMLConverter)converter;
                    for (String formType : this.startEventFormTypes) {
                        startEventConverter.addFormType(formType);
                    }
                }
                converter.convertToBpmnModel(xtr, model, activeProcess, activeSubProcessList);
            }
            for (Process process : model.getProcesses()) {
                this.processFlowElements(process.getFlowElements(), (BaseElement)process);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing BPMN document", (Throwable)e);
            throw new XMLException("Error processing BPMN document", e);
        }
        return model;
    }

    private void processFlowElements(Collection<FlowElement> flowElementList, BaseElement parentScope) {
        for (FlowElement flowElement : flowElementList) {
            if (flowElement instanceof SequenceFlow) {
                FlowNode targetNode;
                SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
                FlowNode sourceNode = this.getFlowNodeFromScope(sequenceFlow.getSourceRef(), parentScope);
                if (sourceNode != null) {
                    sourceNode.getOutgoingFlows().add(sequenceFlow);
                }
                if ((targetNode = this.getFlowNodeFromScope(sequenceFlow.getTargetRef(), parentScope)) == null) continue;
                targetNode.getIncomingFlows().add(sequenceFlow);
                continue;
            }
            if (flowElement instanceof BoundaryEvent) {
                BoundaryEvent boundaryEvent = (BoundaryEvent)flowElement;
                FlowNode attachedToElement = this.getFlowNodeFromScope(boundaryEvent.getAttachedToRefId(), parentScope);
                if (attachedToElement == null) continue;
                boundaryEvent.setAttachedToRef((Activity)attachedToElement);
                ((Activity)attachedToElement).getBoundaryEvents().add(boundaryEvent);
                continue;
            }
            if (!(flowElement instanceof SubProcess)) continue;
            SubProcess subProcess = (SubProcess)flowElement;
            this.processFlowElements(subProcess.getFlowElements(), (BaseElement)subProcess);
        }
    }

    private FlowNode getFlowNodeFromScope(String elementId, BaseElement scope) {
        FlowNode flowNode = null;
        if (StringUtils.isNotEmpty((String)elementId)) {
            if (scope instanceof Process) {
                flowNode = (FlowNode)((Process)scope).getFlowElement(elementId);
            } else if (scope instanceof SubProcess) {
                flowNode = (FlowNode)((SubProcess)scope).getFlowElement(elementId);
            }
        }
        return flowNode;
    }

    public byte[] convertToXML(BpmnModel model) {
        return this.convertToXML(model, DEFAULT_ENCODING);
    }

    public byte[] convertToXML(BpmnModel model, String encoding) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream, encoding);
            XMLStreamWriter writer = xof.createXMLStreamWriter(out);
            IndentingXMLStreamWriter xtw = new IndentingXMLStreamWriter(writer);
            DefinitionsRootExport.writeRootElement(model, xtw, encoding);
            SignalAndMessageDefinitionExport.writeSignalsAndMessages(model, xtw);
            PoolExport.writePools(model, xtw);
            for (Process process : model.getProcesses()) {
                if (process.getFlowElements().size() == 0 && process.getLanes().size() == 0) continue;
                ProcessExport.writeProcess(process, xtw);
                for (FlowElement flowElement : process.getFlowElements()) {
                    this.createXML(flowElement, model, (XMLStreamWriter)xtw);
                }
                for (Artifact artifact : process.getArtifacts()) {
                    this.createXML(artifact, model, (XMLStreamWriter)xtw);
                }
                xtw.writeEndElement();
            }
            BPMNDIExport.writeBPMNDI(model, xtw);
            xtw.writeEndElement();
            xtw.writeEndDocument();
            xtw.flush();
            outputStream.close();
            xtw.close();
            return outputStream.toByteArray();
        }
        catch (Exception e) {
            LOGGER.error("Error writing BPMN XML", (Throwable)e);
            throw new XMLException("Error writing BPMN XML", e);
        }
    }

    private void createXML(FlowElement flowElement, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        if (flowElement instanceof SubProcess) {
            boolean wroteListener;
            SubProcess subProcess = (SubProcess)flowElement;
            xtw.writeStartElement("subProcess");
            xtw.writeAttribute("id", subProcess.getId());
            if (StringUtils.isNotEmpty((String)subProcess.getName())) {
                xtw.writeAttribute("name", subProcess.getName());
            } else {
                xtw.writeAttribute("name", "subProcess");
            }
            if (subProcess instanceof EventSubProcess) {
                xtw.writeAttribute("triggeredByEvent", "true");
            }
            if (StringUtils.isNotEmpty((String)subProcess.getDocumentation())) {
                xtw.writeStartElement("documentation");
                xtw.writeCharacters(subProcess.getDocumentation());
                xtw.writeEndElement();
            }
            if (wroteListener = ActivitiListenerExport.writeListeners((BaseElement)subProcess, false, xtw)) {
                xtw.writeEndElement();
            }
            MultiInstanceExport.writeMultiInstance((Activity)subProcess, xtw);
            for (FlowElement subElement : subProcess.getFlowElements()) {
                this.createXML(subElement, model, xtw);
            }
            for (Artifact artifact : subProcess.getArtifacts()) {
                this.createXML(artifact, model, xtw);
            }
            xtw.writeEndElement();
        } else {
            Class<? extends BaseBpmnXMLConverter> converter = convertersToXMLMap.get(flowElement.getClass());
            if (converter == null) {
                throw new XMLException("No converter for " + flowElement.getClass() + " found");
            }
            converter.newInstance().convertToXML(xtw, (BaseElement)flowElement, model);
        }
    }

    private void createXML(Artifact artifact, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        Class<? extends BaseBpmnXMLConverter> converter = convertersToXMLMap.get(artifact.getClass());
        if (converter == null) {
            throw new XMLException("No converter for " + artifact.getClass() + " found");
        }
        converter.newInstance().convertToXML(xtw, (BaseElement)artifact, model);
    }

    static {
        BpmnXMLConverter.addConverter(EndEventXMLConverter.getXMLType(), EndEventXMLConverter.getBpmnElementType(), EndEventXMLConverter.class);
        BpmnXMLConverter.addConverter(StartEventXMLConverter.getXMLType(), StartEventXMLConverter.getBpmnElementType(), StartEventXMLConverter.class);
        BpmnXMLConverter.addConverter(BusinessRuleTaskXMLConverter.getXMLType(), BusinessRuleTaskXMLConverter.getBpmnElementType(), BusinessRuleTaskXMLConverter.class);
        BpmnXMLConverter.addConverter(ManualTaskXMLConverter.getXMLType(), ManualTaskXMLConverter.getBpmnElementType(), ManualTaskXMLConverter.class);
        BpmnXMLConverter.addConverter(ReceiveTaskXMLConverter.getXMLType(), ReceiveTaskXMLConverter.getBpmnElementType(), ReceiveTaskXMLConverter.class);
        BpmnXMLConverter.addConverter(ScriptTaskXMLConverter.getXMLType(), ScriptTaskXMLConverter.getBpmnElementType(), ScriptTaskXMLConverter.class);
        BpmnXMLConverter.addConverter(ServiceTaskXMLConverter.getXMLType(), ServiceTaskXMLConverter.getBpmnElementType(), ServiceTaskXMLConverter.class);
        BpmnXMLConverter.addConverter(SendTaskXMLConverter.getXMLType(), SendTaskXMLConverter.getBpmnElementType(), SendTaskXMLConverter.class);
        BpmnXMLConverter.addConverter(UserTaskXMLConverter.getXMLType(), UserTaskXMLConverter.getBpmnElementType(), UserTaskXMLConverter.class);
        BpmnXMLConverter.addConverter(TaskXMLConverter.getXMLType(), TaskXMLConverter.getBpmnElementType(), TaskXMLConverter.class);
        BpmnXMLConverter.addConverter(CallActivityXMLConverter.getXMLType(), CallActivityXMLConverter.getBpmnElementType(), CallActivityXMLConverter.class);
        BpmnXMLConverter.addConverter(EventGatewayXMLConverter.getXMLType(), EventGatewayXMLConverter.getBpmnElementType(), EventGatewayXMLConverter.class);
        BpmnXMLConverter.addConverter(ExclusiveGatewayXMLConverter.getXMLType(), ExclusiveGatewayXMLConverter.getBpmnElementType(), ExclusiveGatewayXMLConverter.class);
        BpmnXMLConverter.addConverter(InclusiveGatewayXMLConverter.getXMLType(), InclusiveGatewayXMLConverter.getBpmnElementType(), InclusiveGatewayXMLConverter.class);
        BpmnXMLConverter.addConverter(ParallelGatewayXMLConverter.getXMLType(), ParallelGatewayXMLConverter.getBpmnElementType(), ParallelGatewayXMLConverter.class);
        BpmnXMLConverter.addConverter(SequenceFlowXMLConverter.getXMLType(), SequenceFlowXMLConverter.getBpmnElementType(), SequenceFlowXMLConverter.class);
        BpmnXMLConverter.addConverter(CatchEventXMLConverter.getXMLType(), CatchEventXMLConverter.getBpmnElementType(), CatchEventXMLConverter.class);
        BpmnXMLConverter.addConverter(ThrowEventXMLConverter.getXMLType(), ThrowEventXMLConverter.getBpmnElementType(), ThrowEventXMLConverter.class);
        BpmnXMLConverter.addConverter(BoundaryEventXMLConverter.getXMLType(), BoundaryEventXMLConverter.getBpmnElementType(), BoundaryEventXMLConverter.class);
        BpmnXMLConverter.addConverter(TextAnnotationXMLConverter.getXMLType(), TextAnnotationXMLConverter.getBpmnElementType(), TextAnnotationXMLConverter.class);
        BpmnXMLConverter.addConverter(AssociationXMLConverter.getXMLType(), AssociationXMLConverter.getBpmnElementType(), AssociationXMLConverter.class);
        BpmnXMLConverter.addConverter(AlfrescoStartEventXMLConverter.getXMLType(), AlfrescoStartEventXMLConverter.getBpmnElementType(), AlfrescoStartEventXMLConverter.class);
        BpmnXMLConverter.addConverter(AlfrescoUserTaskXMLConverter.getXMLType(), AlfrescoUserTaskXMLConverter.getBpmnElementType(), AlfrescoUserTaskXMLConverter.class);
    }
}

