/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.ExecutionQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.ProcessInstanceQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;

public class ExecutionEntityManager
extends AbstractManager {
    public void deleteProcessInstancesByProcessDefinition(String processDefinitionId, String deleteReason, boolean cascade) {
        List processInstanceIds = this.getDbSqlSession().selectList("selectProcessInstanceIdsByProcessDefinitionId", processDefinitionId);
        for (String processInstanceId : processInstanceIds) {
            this.deleteProcessInstance(processInstanceId, deleteReason, cascade);
        }
        if (cascade) {
            Context.getCommandContext().getHistoricProcessInstanceEntityManager().deleteHistoricProcessInstanceByProcessDefinitionId(processDefinitionId);
        }
    }

    public void deleteProcessInstance(String processInstanceId, String deleteReason) {
        this.deleteProcessInstance(processInstanceId, deleteReason, false);
    }

    public void deleteProcessInstance(String processInstanceId, String deleteReason, boolean cascade) {
        ExecutionEntity execution = this.findExecutionById(processInstanceId);
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("No process instance found for id '" + processInstanceId + "'", ProcessInstance.class);
        }
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getTaskEntityManager().deleteTasksByProcessInstanceId(processInstanceId, deleteReason, cascade);
        execution.deleteCascade(deleteReason);
        if (cascade) {
            commandContext.getHistoricProcessInstanceEntityManager().deleteHistoricProcessInstanceById(processInstanceId);
        }
    }

    public ExecutionEntity findSubProcessInstanceBySuperExecutionId(String superExecutionId) {
        return (ExecutionEntity)this.getDbSqlSession().selectOne("selectSubProcessInstanceBySuperExecutionId", superExecutionId);
    }

    public List<ExecutionEntity> findChildExecutionsByParentExecutionId(String parentExecutionId) {
        return this.getDbSqlSession().selectList("selectExecutionsByParentExecutionId", parentExecutionId);
    }

    public List<ExecutionEntity> findChildExecutionsByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectExecutionsByProcessInstanceId", processInstanceId);
    }

    public ExecutionEntity findExecutionById(String executionId) {
        return this.getDbSqlSession().selectById(ExecutionEntity.class, executionId);
    }

    public long findExecutionCountByQueryCriteria(ExecutionQueryImpl executionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectExecutionCountByQueryCriteria", executionQuery);
    }

    public List<ExecutionEntity> findExecutionsByQueryCriteria(ExecutionQueryImpl executionQuery, Page page) {
        return this.getDbSqlSession().selectList("selectExecutionsByQueryCriteria", executionQuery, page);
    }

    public long findProcessInstanceCountByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectProcessInstanceCountByQueryCriteria", executionQuery);
    }

    public List<ProcessInstance> findProcessInstanceByQueryCriteria(ProcessInstanceQueryImpl executionQuery, Page page) {
        return this.getDbSqlSession().selectList("selectProcessInstanceByQueryCriteria", executionQuery, page);
    }

    public List<ProcessInstance> findProcessInstanceAndVariablesByQueryCriteria(ProcessInstanceQueryImpl executionQuery, Page page) {
        return this.getDbSqlSession().selectList("selectProcessInstanceWithVariablesByQueryCriteria", executionQuery, page);
    }

    public List<ExecutionEntity> findEventScopeExecutionsByActivityId(String activityRef, String parentExecutionId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("activityId", activityRef);
        parameters.put("parentExecutionId", parentExecutionId);
        return this.getDbSqlSession().selectList("selectExecutionsByParentExecutionId", parameters);
    }

    public List<Execution> findExecutionsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectExecutionByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public List<ProcessInstance> findProcessInstanceByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectExecutionByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findExecutionCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectExecutionCountByNativeQuery", parameterMap);
    }
}

