/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.Signal;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.apache.commons.lang.StringUtils;

public class SignalEventDefinitionParseHandler
extends AbstractBpmnParseHandler<SignalEventDefinition> {
    @Override
    public Class<? extends BaseElement> getHandledType() {
        return SignalEventDefinition.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, SignalEventDefinition signalDefinition) {
        Signal signal = null;
        if (bpmnParse.getBpmnModel().containsSignalId(signalDefinition.getSignalRef())) {
            signal = bpmnParse.getBpmnModel().getSignal(signalDefinition.getSignalRef());
            String signalName = signal.getName();
            if (StringUtils.isEmpty((String)signalName)) {
                bpmnParse.getBpmnModel().addProblem("signalName is required for a signal event", (BaseElement)signalDefinition);
            }
            signalDefinition.setSignalRef(signalName);
        }
        if (signal == null) {
            return;
        }
        ActivityImpl activity = bpmnParse.getCurrentActivity();
        if (bpmnParse.getCurrentFlowElement() instanceof StartEvent) {
            EventSubscriptionDeclaration eventSubscriptionDeclaration = new EventSubscriptionDeclaration(signalDefinition.getSignalRef(), "signal");
            eventSubscriptionDeclaration.setActivityId(activity.getId());
            eventSubscriptionDeclaration.setStartEvent(false);
            this.addEventSubscriptionDeclaration(bpmnParse, eventSubscriptionDeclaration, (EventDefinition)signalDefinition, bpmnParse.getCurrentScope());
        } else if (bpmnParse.getCurrentFlowElement() instanceof IntermediateCatchEvent) {
            activity.setProperty("type", "intermediateSignalCatch");
            EventSubscriptionDeclaration eventSubscriptionDeclaration = new EventSubscriptionDeclaration(signalDefinition.getSignalRef(), "signal");
            if (signal.getScope() != null) {
                eventSubscriptionDeclaration.setConfiguration(signal.getScope());
            }
            if (this.getPrecedingEventBasedGateway(bpmnParse, (IntermediateCatchEvent)bpmnParse.getCurrentFlowElement()) != null) {
                eventSubscriptionDeclaration.setActivityId(activity.getId());
                this.addEventSubscriptionDeclaration(bpmnParse, eventSubscriptionDeclaration, (EventDefinition)signalDefinition, activity.getParent());
            } else {
                activity.setScope(true);
                this.addEventSubscriptionDeclaration(bpmnParse, eventSubscriptionDeclaration, (EventDefinition)signalDefinition, activity);
            }
        } else if (bpmnParse.getCurrentFlowElement() instanceof ThrowEvent) {
            ThrowEvent throwEvent = (ThrowEvent)bpmnParse.getCurrentFlowElement();
            activity.setProperty("type", "intermediateSignalThrow");
            EventSubscriptionDeclaration eventSubscriptionDeclaration = new EventSubscriptionDeclaration(signalDefinition.getSignalRef(), "signal");
            eventSubscriptionDeclaration.setAsync(signalDefinition.isAsync());
            activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createIntermediateThrowSignalEventActivityBehavior(throwEvent, signal, eventSubscriptionDeclaration));
        } else if (bpmnParse.getCurrentFlowElement() instanceof BoundaryEvent) {
            BoundaryEvent boundaryEvent = (BoundaryEvent)bpmnParse.getCurrentFlowElement();
            boolean interrupting = boundaryEvent.isCancelActivity();
            activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createBoundaryEventActivityBehavior(boundaryEvent, interrupting, activity));
            activity.setProperty("type", "boundarySignal");
            EventSubscriptionDeclaration eventSubscriptionDeclaration = new EventSubscriptionDeclaration(signalDefinition.getSignalRef(), "signal");
            eventSubscriptionDeclaration.setActivityId(activity.getId());
            if (signal.getScope() != null) {
                eventSubscriptionDeclaration.setConfiguration(signal.getScope());
            }
            this.addEventSubscriptionDeclaration(bpmnParse, eventSubscriptionDeclaration, (EventDefinition)signalDefinition, activity.getParent());
            if (activity.getParent() instanceof ActivityImpl) {
                ((ActivityImpl)activity.getParent()).setScope(true);
            }
        }
    }
}

