/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.NotFoundException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.PropertiesAwareDataBinding;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.jaxrs.JAXRSBindingFactory;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.model.BeanParamInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.provider.DataBindingProvider;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;

public class AbstractJAXRSFactoryBean
extends AbstractEndpointFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractJAXRSFactoryBean.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractJAXRSFactoryBean.class);
    protected List<String> schemaLocations;
    protected JAXRSServiceFactoryBean serviceFactory;
    protected List<?> entityProviders;

    protected AbstractJAXRSFactoryBean(JAXRSServiceFactoryBean serviceFactory) {
        this.serviceFactory = serviceFactory;
        this.setBindingId("http://apache.org/cxf/binding/jaxrs");
    }

    public Bus getBus() {
        Bus b = super.getBus();
        this.checkBindingFactory(b);
        return b;
    }

    public void setServiceName(QName name) {
        super.setServiceName(name);
        this.serviceFactory.setServiceName(name);
    }

    private void checkBindingFactory(Bus bus) {
        BindingFactoryManager bfm = (BindingFactoryManager)bus.getExtension(BindingFactoryManager.class);
        try {
            bfm.getBindingFactory("http://apache.org/cxf/binding/jaxrs");
        }
        catch (Throwable b) {
            bfm.registerBindingFactory("http://apache.org/cxf/binding/jaxrs", (BindingFactory)new JAXRSBindingFactory(bus));
        }
    }

    public void setBus(Bus bus) {
        super.setBus(bus);
        this.checkBindingFactory(bus);
        this.serviceFactory.setBus(bus);
    }

    protected EndpointInfo createEndpointInfo(Service service) throws BusException {
        String transportId = this.getTransportId();
        if (transportId == null && this.getAddress() != null) {
            DestinationFactory df = this.getDestinationFactory();
            if (df == null) {
                DestinationFactoryManager dfm = (DestinationFactoryManager)this.getBus().getExtension(DestinationFactoryManager.class);
                df = dfm.getDestinationFactoryForUri(this.getAddress());
            }
            if (df != null) {
                transportId = (String)df.getTransportIds().get(0);
            }
        }
        if (transportId == null) {
            transportId = "http://cxf.apache.org/transports/http";
        }
        this.setTransportId(transportId);
        EndpointInfo ei = new EndpointInfo();
        ei.setTransportId(transportId);
        ei.setName(this.serviceFactory.getService().getName());
        ei.setAddress(this.getAddress());
        BindingInfo bindingInfo = this.createBindingInfo();
        ei.setBinding(bindingInfo);
        if (!StringUtils.isEmpty((String)this.publishedEndpointUrl)) {
            ei.setProperty("publishedEndpointUrl", (Object)this.publishedEndpointUrl);
        }
        ei.setName(service.getName());
        this.serviceFactory.sendEvent(FactoryBeanListener.Event.ENDPOINTINFO_CREATED, new Object[]{ei});
        return ei;
    }

    protected BindingInfo createBindingInfo() {
        BindingFactoryManager mgr = (BindingFactoryManager)this.getBus().getExtension(BindingFactoryManager.class);
        String binding = this.getBindingId();
        BindingConfiguration bindingConfig = this.getBindingConfig();
        if (binding == null && bindingConfig != null) {
            binding = bindingConfig.getBindingId();
        }
        if (binding == null) {
            binding = "http://apache.org/cxf/binding/jaxrs";
        }
        try {
            BindingFactory bindingFactory = mgr.getBindingFactory(binding);
            this.setBindingFactory(bindingFactory);
            BindingInfo bi = bindingFactory.createBindingInfo(this.serviceFactory.getService(), binding, (Object)bindingConfig);
            for (BindingOperationInfo boi : bi.getOperations()) {
                this.serviceFactory.sendEvent(FactoryBeanListener.Event.BINDING_OPERATION_CREATED, new Object[]{bi, boi, null});
            }
            this.serviceFactory.sendEvent(FactoryBeanListener.Event.BINDING_CREATED, new Object[]{bi});
            return bi;
        }
        catch (BusException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public JAXRSServiceFactoryBean getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(JAXRSServiceFactoryBean serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    protected Endpoint createEndpoint() throws BusException, EndpointException {
        Service service = this.serviceFactory.getService();
        if (service == null) {
            service = this.serviceFactory.create();
        }
        EndpointInfo ei = this.createEndpointInfo(service);
        EndpointImpl ep = new EndpointImpl(this.getBus(), service, ei);
        if (this.properties != null) {
            ep.putAll(this.properties);
        }
        if (this.getInInterceptors() != null) {
            ep.getInInterceptors().addAll(this.getInInterceptors());
        }
        if (this.getOutInterceptors() != null) {
            ep.getOutInterceptors().addAll(this.getOutInterceptors());
        }
        if (this.getInFaultInterceptors() != null) {
            ep.getInFaultInterceptors().addAll(this.getInFaultInterceptors());
        }
        if (this.getOutFaultInterceptors() != null) {
            ep.getOutFaultInterceptors().addAll(this.getOutFaultInterceptors());
        }
        List<ClassResourceInfo> list = this.serviceFactory.getRealClassResourceInfo();
        for (ClassResourceInfo cri : list) {
            this.initializeAnnotationInterceptors((Endpoint)ep, cri.getServiceClass());
            this.serviceFactory.sendEvent(FactoryBeanListener.Event.ENDPOINT_SELECTED, new Object[]{ei, ep, cri.getServiceClass(), null});
        }
        return ep;
    }

    public void setSchemaLocation(String schema) {
        this.setSchemaLocations(Collections.singletonList(schema));
    }

    public void setSchemaLocations(List<String> schemas) {
        this.schemaLocations = schemas;
    }

    public List<?> getProviders() {
        return this.entityProviders;
    }

    public void setProviders(List<? extends Object> providers) {
        this.entityProviders = providers;
    }

    public void setProvider(Object provider) {
        this.setProviders(Collections.singletonList(provider));
    }

    protected void checkResources(boolean server) {
        List<ClassResourceInfo> list = this.serviceFactory.getRealClassResourceInfo();
        if (server) {
            Iterator<ClassResourceInfo> it = list.iterator();
            while (it.hasNext()) {
                ClassResourceInfo cri = it.next();
                if (!cri.isCreatedFromModel() || cri.getServiceClass() != cri.getResourceClass() || InjectionUtils.isConcreteClass(cri.getServiceClass())) continue;
                it.remove();
            }
        }
        if (list.size() == 0) {
            Message msg = new Message("NO_RESOURCES_AVAILABLE", BUNDLE, new Object[0]);
            LOG.severe(msg.toString());
            throw new NotFoundException();
        }
    }

    protected ProviderFactory setupFactory(Endpoint ep) {
        ProviderFactory factory = ProviderFactory.createInstance(this.getBus());
        if (this.entityProviders != null) {
            factory.setUserProviders(this.entityProviders);
        }
        this.setDataBindingProvider(factory, ep.getService());
        factory.setBus(this.getBus());
        factory.initProviders(this.serviceFactory.getRealClassResourceInfo());
        if (this.schemaLocations != null) {
            factory.setSchemaLocations(this.schemaLocations);
        }
        this.setBeanInfo(factory);
        ep.put((Object)ProviderFactory.class.getName(), (Object)factory);
        this.getBus().setProperty(ProviderFactory.class.getName(), (Object)factory);
        return factory;
    }

    protected void setBeanInfo(ProviderFactory factory) {
        List<ClassResourceInfo> cris = this.serviceFactory.getClassResourceInfo();
        for (ClassResourceInfo cri : cris) {
            Set<OperationResourceInfo> oris = cri.getMethodDispatcher().getOperationResourceInfos();
            for (OperationResourceInfo ori : oris) {
                List<Parameter> params = ori.getParameters();
                for (Parameter param : params) {
                    if (param.getType() != ParameterType.BEAN) continue;
                    Class<?> cls = ori.getMethodToInvoke().getParameterTypes()[param.getIndex()];
                    BeanParamInfo bpi = new BeanParamInfo(cls, this.getBus());
                    factory.addBeanParamInfo(bpi);
                }
            }
        }
    }

    protected void setDataBindingProvider(ProviderFactory factory, Service s) {
        DataBinding db;
        org.apache.cxf.annotations.DataBinding ann;
        List<ClassResourceInfo> cris = this.serviceFactory.getRealClassResourceInfo();
        if (this.getDataBinding() == null && cris.size() > 0 && (ann = cris.get(0).getServiceClass().getAnnotation(org.apache.cxf.annotations.DataBinding.class)) != null) {
            try {
                this.setDataBinding((DataBinding)ann.value().newInstance());
            }
            catch (Exception ex) {
                LOG.warning("DataBinding " + ann.value() + " can not be loaded");
            }
        }
        if ((db = this.getDataBinding()) == null) {
            return;
        }
        if (db instanceof PropertiesAwareDataBinding) {
            Map<Class<?>, Type> allClasses = ResourceUtils.getAllRequestResponseTypes(cris, false).getAllTypes();
            HashMap props = new HashMap();
            props.put("org.apache.cxf.databinding.types", allClasses);
            ((PropertiesAwareDataBinding)db).initialize(props);
        } else {
            if (s instanceof JAXRSServiceImpl) {
                ((JAXRSServiceImpl)s).setCreateServiceModel(true);
            }
            db.initialize(s);
        }
        factory.setUserProviders(Collections.singletonList(new DataBindingProvider(db)));
    }

    public void setModelBeans(UserResource ... resources) {
        this.setModelBeans(Arrays.asList(resources));
    }

    public void setModelBeans(List<UserResource> resources) {
        this.serviceFactory.setUserResources(resources);
    }

    public void setModelBeansWithServiceClass(List<UserResource> resources, Class<?> ... sClasses) {
        this.serviceFactory.setUserResourcesWithServiceClass(resources, sClasses);
    }

    public void setModelRef(String modelRef) {
        List<UserResource> resources = ResourceUtils.getUserResources(modelRef, this.getBus());
        if (resources != null) {
            this.serviceFactory.setUserResources(resources);
        }
    }

    public void setModelRefWithServiceClass(String modelRef, Class<?> ... sClasses) {
        List<UserResource> resources = ResourceUtils.getUserResources(modelRef, this.getBus());
        if (resources != null) {
            this.serviceFactory.setUserResourcesWithServiceClass(resources, sClasses);
        }
    }
}

