/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.encoding;

import org.springframework.security.crypto.codec.Utf8;

class PasswordEncoderUtils {
    static boolean equals(String expected, String actual) {
        int actualLength;
        byte[] expectedBytes = PasswordEncoderUtils.bytesUtf8(expected);
        byte[] actualBytes = PasswordEncoderUtils.bytesUtf8(actual);
        int expectedLength = expectedBytes == null ? -1 : expectedBytes.length;
        int n = actualLength = actualBytes == null ? -1 : actualBytes.length;
        if (expectedLength != actualLength) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < expectedLength; ++i) {
            result |= expectedBytes[i] ^ actualBytes[i];
        }
        return result == 0;
    }

    private static byte[] bytesUtf8(String s) {
        if (s == null) {
            return null;
        }
        return Utf8.encode(s);
    }

    private PasswordEncoderUtils() {
    }
}

