/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils.multipart;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.multipart.MultipartReadException;
import org.apache.cxf.phase.PhaseInterceptorChain;

public final class AttachmentUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSUtils.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSUtils.class);

    private AttachmentUtils() {
    }

    public static MultipartBody getMultipartBody(MessageContext mc) {
        return (MultipartBody)mc.get("org.apache.cxf.jaxrs.attachments.inbound");
    }

    public static Map<String, Attachment> getChildAttachmentsMap(MessageContext mc) {
        return AttachmentUtils.fromListToMap(AttachmentUtils.getChildAttachments(mc));
    }

    public static List<Attachment> getChildAttachments(MessageContext mc) {
        return ((MultipartBody)mc.get("org.apache.cxf.jaxrs.attachments.inbound")).getChildAttachments();
    }

    public static Map<String, Attachment> getAttachmentsMap(MessageContext mc) {
        return AttachmentUtils.fromListToMap(AttachmentUtils.getAttachments(mc));
    }

    public static List<Attachment> getAttachments(MessageContext mc) {
        return ((MultipartBody)mc.get("org.apache.cxf.jaxrs.attachments.inbound")).getAllAttachments();
    }

    public static MultipartBody getMultipartBody(MessageContext mc, String attachmentDir, String attachmentThreshold, String attachmentMaxSize) {
        if (attachmentDir != null) {
            mc.put("attachment-directory", attachmentDir);
        }
        if (attachmentThreshold != null) {
            mc.put("attachment-memory-threshold", attachmentThreshold);
        }
        if (attachmentMaxSize != null) {
            mc.put("attachment-max-size", attachmentMaxSize);
        }
        boolean embeddedAttachment = mc.get("org.apache.cxf.multipart.embedded") != null;
        String propertyName = embeddedAttachment ? "org.apache.cxf.jaxrs.attachments.inbound.embedded" : "org.apache.cxf.jaxrs.attachments.inbound";
        return (MultipartBody)mc.get(propertyName);
    }

    public static List<Attachment> getAttachments(MessageContext mc, String attachmentDir, String attachmentThreshold, String attachmentMaxSize) {
        return AttachmentUtils.getMultipartBody(mc, attachmentDir, attachmentThreshold, attachmentMaxSize).getAllAttachments();
    }

    public static Attachment getMultipart(Multipart id, MediaType mt, List<Attachment> infos) throws IOException {
        if (id != null) {
            for (Attachment a : infos) {
                if (!AttachmentUtils.matchAttachmentId(a, id, mt)) continue;
                AttachmentUtils.checkMediaTypes(a.getContentType(), id.type());
                return a;
            }
            if (id.required()) {
                Message errorMsg = new Message("MULTTIPART_ID_NOT_FOUND", BUNDLE, new Object[]{id.value(), mt.toString()});
                LOG.warning(errorMsg.toString());
                throw new BadRequestException((Throwable)new MultipartReadException(id.value(), id.type(), errorMsg.toString()));
            }
            return null;
        }
        return infos.size() > 0 ? infos.get(0) : null;
    }

    public static List<Attachment> getAllMultiparts(Multipart id, MediaType mt, List<Attachment> infos) throws IOException {
        LinkedList<Attachment> all = new LinkedList<Attachment>();
        for (Attachment a : infos) {
            if (!AttachmentUtils.matchAttachmentId(a, id, mt)) continue;
            AttachmentUtils.checkMediaTypes(a.getContentType(), id.type());
            all.add(a);
        }
        return all;
    }

    private static boolean matchAttachmentId(Attachment at, Multipart mid, MediaType multipartType) {
        if (at.getContentId().equals(mid.value())) {
            return true;
        }
        ContentDisposition cd = at.getContentDisposition();
        return cd != null && mid.value().equals(cd.getParameter("name"));
    }

    public static MultivaluedMap<String, String> populateFormMap(MessageContext mc, boolean errorIfMissing) {
        MetadataMap<String, String> data = new MetadataMap<String, String>();
        FormUtils.populateMapFromMultipart(data, AttachmentUtils.getMultipartBody(mc), PhaseInterceptorChain.getCurrentMessage(), true);
        return data;
    }

    public static MultivaluedMap<String, String> populateFormMap(MessageContext mc) {
        return AttachmentUtils.populateFormMap(mc, true);
    }

    private static Map<String, Attachment> fromListToMap(List<Attachment> atts) {
        LinkedHashMap<String, Attachment> map = new LinkedHashMap<String, Attachment>();
        for (Attachment a : atts) {
            map.put(a.getContentId(), a);
        }
        return map;
    }

    private static void checkMediaTypes(MediaType mt1, String mt2) {
        if (!mt1.isCompatible(JAXRSUtils.toMediaType(mt2))) {
            throw new NotSupportedException();
        }
    }
}

