/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.alfresco.AlfrescoStartEvent;
import org.apache.commons.lang.StringUtils;

public class StartEventXMLConverter
extends BaseBpmnXMLConverter {
    List<String> formTypes = new ArrayList<String>();

    public static String getXMLType() {
        return "startEvent";
    }

    public static Class<? extends BaseElement> getBpmnElementType() {
        return StartEvent.class;
    }

    @Override
    protected String getXMLElementName() {
        return "startEvent";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr) throws Exception {
        String formKey = xtr.getAttributeValue("http://activiti.org/bpmn", "formKey");
        StartEvent startEvent = null;
        if (StringUtils.isNotEmpty((String)formKey) && this.formTypes.contains(formKey)) {
            startEvent = new AlfrescoStartEvent();
        }
        if (startEvent == null) {
            startEvent = new StartEvent();
        }
        BpmnXMLUtil.addXMLLocation(startEvent, xtr);
        startEvent.setInitiator(xtr.getAttributeValue("http://activiti.org/bpmn", "initiator"));
        startEvent.setFormKey(formKey);
        this.parseChildElements(this.getXMLElementName(), (BaseElement)startEvent, xtr);
        return startEvent;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, XMLStreamWriter xtw) throws Exception {
        StartEvent startEvent = (StartEvent)element;
        this.writeQualifiedAttribute("initiator", startEvent.getInitiator(), xtw);
        this.writeQualifiedAttribute("formKey", startEvent.getFormKey(), xtw);
    }

    @Override
    protected void writeExtensionChildElements(BaseElement element, XMLStreamWriter xtw) throws Exception {
        StartEvent startEvent = (StartEvent)element;
        this.writeFormProperties((FlowElement)startEvent, xtw);
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, XMLStreamWriter xtw) throws Exception {
        StartEvent startEvent = (StartEvent)element;
        this.writeEventDefinitions(startEvent.getEventDefinitions(), xtw);
    }

    public void addFormType(String formType) {
        if (StringUtils.isNotEmpty((String)formType)) {
            this.formTypes.add(formType);
        }
    }
}

