/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.util;

import org.apache.cocoon.pipeline.util.MurmurHash;

public class MurmurHashCodeBuilder {
    private byte[] bytes = new byte[0];

    public MurmurHashCodeBuilder append(byte[] byteArray) {
        if (byteArray == null) {
            return this;
        }
        byte[] joinedArray = new byte[this.bytes.length + byteArray.length];
        System.arraycopy(this.bytes, 0, joinedArray, 0, this.bytes.length);
        System.arraycopy(byteArray, 0, joinedArray, this.bytes.length, byteArray.length);
        this.bytes = joinedArray;
        return this;
    }

    public MurmurHashCodeBuilder append(int value) {
        return this.append(new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value});
    }

    public MurmurHashCodeBuilder append(long v) {
        return this.append(new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)});
    }

    public MurmurHashCodeBuilder append(String value) {
        if (value == null) {
            return this;
        }
        return this.append(value.getBytes());
    }

    public int toHashCode() {
        return MurmurHash.hash(this.bytes, 1);
    }

    protected byte[] getBytes() {
        return this.bytes;
    }
}

