/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.core.request.handler.ListenerInterfaceRequestHandler;
import org.apache.wicket.core.request.handler.PageAndComponentProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.core.request.mapper.AbstractComponentMapper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.info.ComponentInfo;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.request.mapper.info.PageInfo;

public class PageInstanceMapper
extends AbstractComponentMapper {
    public IRequestHandler mapRequest(Request request) {
        Url url;
        PageComponentInfo info;
        if (this.matches(request) && (info = this.getPageComponentInfo(url = request.getUrl())) != null && info.getPageInfo().getPageId() != null) {
            Integer renderCount;
            Integer n = renderCount = info.getComponentInfo() != null ? info.getComponentInfo().getRenderCount() : null;
            if (info.getComponentInfo() == null) {
                PageProvider provider = new PageProvider(info.getPageInfo().getPageId(), renderCount);
                provider.setPageSource(this.getContext());
                return new RenderPageRequestHandler(provider);
            }
            ComponentInfo componentInfo = info.getComponentInfo();
            PageAndComponentProvider provider = new PageAndComponentProvider((int)info.getPageInfo().getPageId(), renderCount, componentInfo.getComponentPath());
            provider.setPageSource(this.getContext());
            RequestListenerInterface listenerInterface = this.requestListenerInterfaceFromString(componentInfo.getListenerInterface());
            return new ListenerInterfaceRequestHandler(provider, listenerInterface, componentInfo.getBehaviorId());
        }
        return null;
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        PageComponentInfo info = null;
        if (requestHandler instanceof RenderPageRequestHandler) {
            IRequestablePage page = ((RenderPageRequestHandler)requestHandler).getPage();
            PageInfo i = new PageInfo(Integer.valueOf(page.getPageId()));
            info = new PageComponentInfo(i, null);
        } else if (requestHandler instanceof ListenerInterfaceRequestHandler) {
            ListenerInterfaceRequestHandler handler = (ListenerInterfaceRequestHandler)requestHandler;
            IRequestablePage page = handler.getPage();
            String componentPath = handler.getComponentPath();
            RequestListenerInterface listenerInterface = handler.getListenerInterface();
            Integer renderCount = null;
            if (listenerInterface.isIncludeRenderCount()) {
                renderCount = page.getRenderCount();
            }
            PageInfo pageInfo = new PageInfo(Integer.valueOf(page.getPageId()));
            ComponentInfo componentInfo = new ComponentInfo(renderCount, this.requestListenerInterfaceToString(listenerInterface), componentPath, handler.getBehaviorIndex());
            info = new PageComponentInfo(pageInfo, componentInfo);
        }
        if (info != null) {
            Url url = new Url();
            url.getSegments().add(this.getContext().getNamespace());
            url.getSegments().add(this.getContext().getPageIdentifier());
            this.encodePageComponentInfo(url, info);
            return url;
        }
        return null;
    }

    public int getCompatibilityScore(Request request) {
        int score = 0;
        if (this.matches(request)) {
            score = Integer.MAX_VALUE;
        }
        return score;
    }

    private boolean matches(Request request) {
        String pageIdentifier;
        String namespace;
        boolean matches = false;
        Url url = request.getUrl();
        if (this.urlStartsWith(url, new String[]{namespace = this.getContext().getNamespace(), pageIdentifier = this.getContext().getPageIdentifier()})) {
            matches = true;
        } else if (this.urlStartsWith(request.getClientUrl(), new String[]{namespace, pageIdentifier}) && this.urlStartsWith(url, new String[]{pageIdentifier})) {
            matches = true;
        }
        return matches;
    }
}

