/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.test;

import java.util.Date;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.test.TestHelper;
import org.activiti.engine.impl.util.ClockUtil;
import org.junit.rules.TestWatchman;
import org.junit.runners.model.FrameworkMethod;

public class ActivitiRule
extends TestWatchman {
    protected String configurationResource = "activiti.cfg.xml";
    protected String deploymentId = null;
    protected ProcessEngine processEngine;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected FormService formService;

    public ActivitiRule() {
    }

    public ActivitiRule(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public ActivitiRule(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public void starting(FrameworkMethod method) {
        if (this.processEngine == null) {
            this.initializeProcessEngine();
            this.initializeServices();
        }
        this.deploymentId = TestHelper.annotationDeploymentSetUp(this.processEngine, method.getMethod().getDeclaringClass(), method.getName());
    }

    protected void initializeProcessEngine() {
        this.processEngine = TestHelper.getProcessEngine(this.configurationResource);
    }

    protected void initializeServices() {
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.formService = this.processEngine.getFormService();
    }

    public void finished(FrameworkMethod method) {
        TestHelper.annotationDeploymentTearDown(this.processEngine, this.deploymentId, method.getMethod().getDeclaringClass(), method.getName());
        ClockUtil.reset();
    }

    public void setCurrentTime(Date currentTime) {
        ClockUtil.setCurrentTime(currentTime);
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.initializeServices();
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public RuntimeService getRuntimeService() {
        return this.runtimeService;
    }

    public void setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public HistoryService getHistoryService() {
        return this.historyService;
    }

    public void setHistoricDataService(HistoryService historicDataService) {
        this.historyService = historicDataService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public ManagementService getManagementService() {
        return this.managementService;
    }

    public FormService getFormService() {
        return this.formService;
    }

    public void setManagementService(ManagementService managementService) {
        this.managementService = managementService;
    }
}

