/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import org.activiti.engine.impl.persistence.entity.ByteArrayEntity;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;

public class ByteArrayType
implements VariableType {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTypeName() {
        return "bytes";
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        if (valueFields.getByteArrayValueId() == null) {
            return null;
        }
        return valueFields.getByteArrayValue().getBytes();
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        ByteArrayEntity byteArray = valueFields.getByteArrayValue();
        byte[] bytes = (byte[])value;
        if (byteArray == null) {
            valueFields.setByteArrayValue(bytes);
        } else {
            byteArray.setBytes(bytes);
        }
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return byte[].class.isAssignableFrom(value.getClass());
    }
}

