/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Date;
import org.activiti.engine.history.HistoricVariableUpdate;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntity;
import org.activiti.engine.impl.persistence.entity.HistoricDetailEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.util.ClockUtil;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;

public class HistoricDetailVariableInstanceUpdateEntity
extends HistoricDetailEntity
implements ValueFields,
HistoricVariableUpdate,
PersistentObject,
HasRevision {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected int revision;
    protected VariableType variableType;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected ByteArrayEntity byteArrayValue;
    protected String byteArrayValueId;
    protected Object cachedValue;

    public HistoricDetailVariableInstanceUpdateEntity() {
    }

    public HistoricDetailVariableInstanceUpdateEntity(VariableInstanceEntity variableInstance) {
        this.processInstanceId = variableInstance.getProcessInstanceId();
        this.executionId = variableInstance.getExecutionId();
        this.taskId = variableInstance.getTaskId();
        this.revision = variableInstance.getRevision();
        this.name = variableInstance.getName();
        this.variableType = variableInstance.getType();
        this.time = ClockUtil.getCurrentTime();
        if (variableInstance.getByteArrayValueId() != null) {
            this.byteArrayValue = new ByteArrayEntity(this.name, variableInstance.getByteArrayValue().getBytes());
            Context.getCommandContext().getDbSqlSession().insert(this.byteArrayValue);
            this.byteArrayValueId = this.byteArrayValue.getId();
        }
        this.textValue = variableInstance.getTextValue();
        this.textValue2 = variableInstance.getTextValue2();
        this.doubleValue = variableInstance.getDoubleValue();
        this.longValue = variableInstance.getLongValue();
    }

    @Override
    public Object getValue() {
        if (!this.variableType.isCachable() || this.cachedValue == null) {
            this.cachedValue = this.variableType.getValue(this);
        }
        return this.cachedValue;
    }

    @Override
    public void delete() {
        super.delete();
        if (this.byteArrayValueId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayEntityManager().deleteByteArrayById(this.byteArrayValueId);
        }
    }

    @Override
    public Object getPersistentState() {
        return HistoricDetailVariableInstanceUpdateEntity.class;
    }

    @Override
    public String getVariableTypeName() {
        return this.variableType != null ? this.variableType.getTypeName() : null;
    }

    @Override
    public String getByteArrayValueId() {
        return this.byteArrayValueId;
    }

    public void setByteArrayValueId(String byteArrayValueId) {
        this.byteArrayValueId = byteArrayValueId;
        this.byteArrayValue = null;
    }

    @Override
    public ByteArrayEntity getByteArrayValue() {
        if (this.byteArrayValue == null && this.byteArrayValueId != null) {
            this.byteArrayValue = Context.getCommandContext().getDbSqlSession().selectById(ByteArrayEntity.class, this.byteArrayValueId);
        }
        return this.byteArrayValue;
    }

    @Override
    public void setByteArrayValue(byte[] bytes) {
        ByteArrayEntity byteArrayValue = null;
        if (this.byteArrayValueId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayEntityManager().deleteByteArrayById(this.byteArrayValueId);
        }
        if (bytes != null) {
            byteArrayValue = new ByteArrayEntity(bytes);
            Context.getCommandContext().getDbSqlSession().insert(byteArrayValue);
        }
        this.byteArrayValue = byteArrayValue;
        this.byteArrayValueId = byteArrayValue != null ? byteArrayValue.getId() : null;
    }

    protected void deleteByteArrayValue() {
        if (this.byteArrayValueId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayEntityManager().deleteByteArrayById(this.byteArrayValueId);
        }
    }

    @Override
    public Date getTime() {
        return this.time;
    }

    @Override
    public void setTime(Date time) {
        this.time = time;
    }

    @Override
    public String getVariableName() {
        return this.name;
    }

    public VariableType getVariableType() {
        return this.variableType;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Long getLongValue() {
        return this.longValue;
    }

    @Override
    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    @Override
    public Double getDoubleValue() {
        return this.doubleValue;
    }

    @Override
    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    @Override
    public String getTextValue() {
        return this.textValue;
    }

    @Override
    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    @Override
    public String getTextValue2() {
        return this.textValue2;
    }

    @Override
    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    public void setByteArrayValue(ByteArrayEntity byteArrayValue) {
        this.byteArrayValue = byteArrayValue;
    }

    @Override
    public Object getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    public void setVariableType(VariableType variableType) {
        this.variableType = variableType;
    }
}

