/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.CommentEntityManager;
import org.activiti.engine.task.Comment;

public class DeleteCommentCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String processInstanceId;

    public DeleteCommentCmd(String taskId, String processInstanceId) {
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        CommentEntityManager commentManager = commandContext.getCommentEntityManager();
        ArrayList<Comment> comments = new ArrayList<Comment>();
        if (this.processInstanceId != null) {
            comments.addAll(commentManager.findCommentsByProcessInstanceId(this.processInstanceId));
        }
        if (this.taskId != null) {
            comments.addAll(commentManager.findCommentsByTaskId(this.taskId));
        }
        for (Comment comment : comments) {
            commentManager.delete((CommentEntity)comment);
        }
        return null;
    }
}

