/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.Association;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.DataSpec;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.EventGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.IOSpecification;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.bpmn.data.Data;
import org.activiti.engine.impl.bpmn.data.DataRef;
import org.activiti.engine.impl.bpmn.data.ItemDefinition;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.parse.BpmnParseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBpmnParseHandler<T extends BaseElement>
implements BpmnParseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBpmnParseHandler.class);
    public static final String PROPERTYNAME_IS_FOR_COMPENSATION = "isForCompensation";
    public static final String PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION = "eventDefinitions";
    public static final String PROPERTYNAME_ERROR_EVENT_DEFINITIONS = "errorEventDefinitions";
    public static final String PROPERTYNAME_TIMER_DECLARATION = "timerDeclarations";

    public Set<Class<? extends BaseElement>> getHandledTypes() {
        HashSet<Class<? extends BaseElement>> types = new HashSet<Class<? extends BaseElement>>();
        types.add(this.getHandledType());
        return types;
    }

    protected Class<? extends BaseElement> getHandledType() {
        return null;
    }

    @Override
    public void parse(BpmnParse bpmnParse, BaseElement element) {
        BaseElement baseElement = element;
        this.executeParse(bpmnParse, baseElement);
    }

    protected abstract void executeParse(BpmnParse var1, T var2);

    protected ActivityImpl findActivity(BpmnParse bpmnParse, String id) {
        return bpmnParse.getCurrentScope().findActivity(id);
    }

    public ActivityImpl createActivityOnCurrentScope(BpmnParse bpmnParse, FlowElement flowElement, String xmlLocalName) {
        return this.createActivityOnScope(bpmnParse, flowElement, xmlLocalName, bpmnParse.getCurrentScope());
    }

    public ActivityImpl createActivityOnScope(BpmnParse bpmnParse, FlowElement flowElement, String xmlLocalName, ScopeImpl scopeElement) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Parsing activity {}", (Object)flowElement.getId());
        }
        ActivityImpl activity = scopeElement.createActivity(flowElement.getId());
        bpmnParse.setCurrentActivity(activity);
        activity.setProperty("name", flowElement.getName());
        activity.setProperty("documentation", flowElement.getDocumentation());
        if (flowElement instanceof Activity) {
            Activity modelActivity = (Activity)flowElement;
            activity.setProperty("default", modelActivity.getDefaultFlow());
            if (modelActivity.isForCompensation()) {
                activity.setProperty(PROPERTYNAME_IS_FOR_COMPENSATION, true);
            }
        } else if (flowElement instanceof Gateway) {
            activity.setProperty("default", ((Gateway)flowElement).getDefaultFlow());
        }
        activity.setProperty("type", xmlLocalName);
        return activity;
    }

    protected void createExecutionListenersOnScope(BpmnParse bpmnParse, List<ActivitiListener> activitiListenerList, ScopeImpl scope) {
        for (ActivitiListener activitiListener : activitiListenerList) {
            scope.addExecutionListener(activitiListener.getEvent(), this.createExecutionListener(bpmnParse, activitiListener));
        }
    }

    protected void createExecutionListenersOnTransition(BpmnParse bpmnParse, List<ActivitiListener> activitiListenerList, TransitionImpl transition) {
        for (ActivitiListener activitiListener : activitiListenerList) {
            transition.addExecutionListener(this.createExecutionListener(bpmnParse, activitiListener));
        }
    }

    protected ExecutionListener createExecutionListener(BpmnParse bpmnParse, ActivitiListener activitiListener) {
        ExecutionListener executionListener = null;
        if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(activitiListener.getImplementationType())) {
            executionListener = bpmnParse.getListenerFactory().createClassDelegateExecutionListener(activitiListener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
            executionListener = bpmnParse.getListenerFactory().createExpressionExecutionListener(activitiListener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
            executionListener = bpmnParse.getListenerFactory().createDelegateExpressionExecutionListener(activitiListener);
        }
        return executionListener;
    }

    protected void addEventSubscriptionDeclaration(BpmnParse bpmnParse, EventSubscriptionDeclaration subscription, EventDefinition parsedEventDefinition, ScopeImpl scope) {
        ArrayList<EventSubscriptionDeclaration> eventDefinitions = (ArrayList<EventSubscriptionDeclaration>)scope.getProperty(PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION);
        if (eventDefinitions == null) {
            eventDefinitions = new ArrayList<EventSubscriptionDeclaration>();
            scope.setProperty(PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION, eventDefinitions);
        } else if (subscription.getEventType().equals("message")) {
            for (EventSubscriptionDeclaration eventDefinition : eventDefinitions) {
                if (!eventDefinition.getEventType().equals("message") || !eventDefinition.getEventName().equals(subscription.getEventName()) || eventDefinition.isStartEvent() != subscription.isStartEvent()) continue;
                bpmnParse.getBpmnModel().addProblem("Cannot have more than one message event subscription with name '" + subscription.getEventName() + "' for scope '" + scope.getId() + "'", (BaseElement)parsedEventDefinition);
            }
        }
        eventDefinitions.add(subscription);
    }

    protected String getPrecedingEventBasedGateway(BpmnParse bpmnParse, IntermediateCatchEvent event) {
        String eventBasedGatewayId = null;
        for (SequenceFlow sequenceFlow : event.getIncomingFlows()) {
            FlowElement sourceElement = bpmnParse.getBpmnModel().getFlowElement(sequenceFlow.getSourceRef());
            if (!(sourceElement instanceof EventGateway)) continue;
            eventBasedGatewayId = sourceElement.getId();
            break;
        }
        return eventBasedGatewayId;
    }

    protected org.activiti.engine.impl.bpmn.data.IOSpecification createIOSpecification(BpmnParse bpmnParse, IOSpecification specificationModel) {
        DataRef dataRef;
        ItemDefinition itemDefinition;
        org.activiti.engine.impl.bpmn.data.IOSpecification ioSpecification = new org.activiti.engine.impl.bpmn.data.IOSpecification();
        for (DataSpec dataInputElement : specificationModel.getDataInputs()) {
            itemDefinition = bpmnParse.getItemDefinitions().get(dataInputElement.getItemSubjectRef());
            Data dataInput = new Data(bpmnParse.getTargetNamespace() + ":" + dataInputElement.getId(), dataInputElement.getId(), itemDefinition);
            ioSpecification.addInput(dataInput);
        }
        for (DataSpec dataOutputElement : specificationModel.getDataOutputs()) {
            itemDefinition = bpmnParse.getItemDefinitions().get(dataOutputElement.getItemSubjectRef());
            Data dataOutput = new Data(bpmnParse.getTargetNamespace() + ":" + dataOutputElement.getId(), dataOutputElement.getId(), itemDefinition);
            ioSpecification.addOutput(dataOutput);
        }
        for (String dataInputRef : specificationModel.getDataInputRefs()) {
            dataRef = new DataRef(dataInputRef);
            ioSpecification.addInputRef(dataRef);
        }
        for (String dataOutputRef : specificationModel.getDataOutputRefs()) {
            dataRef = new DataRef(dataOutputRef);
            ioSpecification.addOutputRef(dataRef);
        }
        return ioSpecification;
    }

    protected void processArtifacts(BpmnParse bpmnParse, Collection<Artifact> artifacts, ScopeImpl scope) {
        for (Artifact artifact : artifacts) {
            if (!(artifact instanceof Association)) continue;
            this.createAssociation(bpmnParse, (Association)artifact, scope);
        }
    }

    protected void createAssociation(BpmnParse bpmnParse, Association association, ScopeImpl parentScope) {
        BpmnModel bpmnModel = bpmnParse.getBpmnModel();
        if (bpmnModel.getArtifact(association.getSourceRef()) != null || bpmnModel.getArtifact(association.getTargetRef()) != null) {
            return;
        }
        ActivityImpl sourceActivity = parentScope.findActivity(association.getSourceRef());
        ActivityImpl targetActivity = parentScope.findActivity(association.getTargetRef());
        if (sourceActivity != null && targetActivity != null && sourceActivity != null && sourceActivity.getProperty("type").equals("compensationBoundaryCatch")) {
            Object isForCompensation = targetActivity.getProperty(PROPERTYNAME_IS_FOR_COMPENSATION);
            if (isForCompensation == null || !((Boolean)isForCompensation).booleanValue()) {
                bpmnModel.addProblem("compensation boundary catch must be connected to element with isForCompensation=true", (BaseElement)association);
            } else {
                ActivityImpl compensatedActivity = sourceActivity.getParentActivity();
                compensatedActivity.setProperty("compensationHandler", targetActivity.getId());
            }
        }
    }
}

