/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.services;

import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.mod.UserMod;
import org.apache.syncope.common.search.NodeCond;
import org.apache.syncope.common.services.InvalidSearchConditionException;
import org.apache.syncope.common.to.BulkAction;
import org.apache.syncope.common.to.BulkActionRes;
import org.apache.syncope.common.to.PropagationRequestTO;
import org.apache.syncope.common.to.UserTO;

@Path(value="users")
public interface UserService {
    @POST
    @Path(value="{userId}/status/activate")
    public UserTO activate(@PathParam(value="userId") long var1, @QueryParam(value="token") String var3);

    @POST
    @Path(value="{userId}/status/activate/propagation")
    public UserTO activate(@PathParam(value="userId") long var1, @QueryParam(value="token") String var3, PropagationRequestTO var4);

    @POST
    @Path(value="activateByUsername/{username}")
    public UserTO activateByUsername(@PathParam(value="username") String var1, @QueryParam(value="token") String var2);

    @POST
    @Path(value="activateByUsername/{username}/propagation")
    public UserTO activateByUsername(@PathParam(value="username") String var1, @QueryParam(value="token") String var2, PropagationRequestTO var3);

    @GET
    @Path(value="count")
    public int count();

    @POST
    public Response create(UserTO var1);

    @DELETE
    @Path(value="{userId}")
    public UserTO delete(@PathParam(value="userId") Long var1);

    @GET
    public List<UserTO> list();

    @GET
    public List<UserTO> list(@QueryParam(value="page") int var1, @QueryParam(value="size") @DefaultValue(value="25") int var2);

    @POST
    @Path(value="{userId}/status/reactivate")
    public UserTO reactivate(@PathParam(value="userId") long var1);

    @POST
    @Path(value="{userId}/status/reactivate/propagation")
    public UserTO reactivate(@PathParam(value="userId") long var1, PropagationRequestTO var3);

    @POST
    @Path(value="reactivateByUsername/{username}")
    public UserTO reactivateByUsername(@PathParam(value="username") String var1);

    @POST
    @Path(value="reactivateByUsername/{username}/propagation")
    public UserTO reactivateByUsername(@PathParam(value="username") String var1, PropagationRequestTO var2);

    @GET
    @Path(value="{userId}")
    public UserTO read(@PathParam(value="userId") Long var1);

    @GET
    public UserTO read(@QueryParam(value="username") String var1);

    @GET
    @Path(value="self")
    public UserTO readSelf();

    @POST
    @Path(value="search")
    public List<UserTO> search(NodeCond var1) throws InvalidSearchConditionException;

    @POST
    @Path(value="search")
    public List<UserTO> search(NodeCond var1, @QueryParam(value="page") int var2, @QueryParam(value="size") @DefaultValue(value="25") int var3) throws InvalidSearchConditionException;

    @POST
    @Path(value="search/count")
    public int searchCount(NodeCond var1) throws InvalidSearchConditionException;

    @POST
    @Path(value="{userId}/status/suspend")
    public UserTO suspend(@PathParam(value="userId") long var1);

    @POST
    @Path(value="{userId}/status/suspend/propagation")
    public UserTO suspend(@PathParam(value="userId") long var1, PropagationRequestTO var3);

    @POST
    @Path(value="suspendByUsername/{username}")
    public UserTO suspendByUsername(@PathParam(value="username") String var1);

    @POST
    @Path(value="suspendByUsername/{username}/propagation")
    public UserTO suspendByUsername(@PathParam(value="username") String var1, PropagationRequestTO var2);

    @POST
    @Path(value="{userId}")
    public UserTO update(@PathParam(value="userId") Long var1, UserMod var2);

    @POST
    @Path(value="bulk")
    public BulkActionRes bulkAction(BulkAction var1);
}

