/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.services.proxy;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.services.proxy.SpringServiceProxy;
import org.apache.syncope.common.services.PolicyService;
import org.apache.syncope.common.to.AccountPolicyTO;
import org.apache.syncope.common.to.CorrelationRuleClassTO;
import org.apache.syncope.common.to.PasswordPolicyTO;
import org.apache.syncope.common.to.PolicyTO;
import org.apache.syncope.common.to.SyncPolicyTO;
import org.apache.syncope.common.types.PolicyType;
import org.apache.syncope.common.util.CollectionWrapper;
import org.springframework.web.client.RestTemplate;

public class PolicyServiceProxy
extends SpringServiceProxy
implements PolicyService {
    public PolicyServiceProxy(String baseUrl, RestTemplate restTemplate) {
        super(baseUrl, restTemplate);
    }

    public <T extends PolicyTO> Response create(PolicyType type, T policyTO) {
        PolicyTO policy = (PolicyTO)this.getRestTemplate().postForObject(this.baseUrl + "policy/{kind}/create", policyTO, policyTO.getClass(), new Object[]{this.typeToUrl(policyTO.getType())});
        return Response.created((URI)URI.create(this.baseUrl + "policy/read/" + policy.getId() + ".json")).build();
    }

    public <T extends PolicyTO> void delete(PolicyType type, Long policyId) {
        this.getRestTemplate().getForObject(this.baseUrl + "policy/delete/{id}", this.getTOClass(type), new Object[]{policyId});
    }

    public <T extends PolicyTO> List<T> list(PolicyType type) {
        List<Object> result = null;
        switch (type) {
            case ACCOUNT: 
            case GLOBAL_ACCOUNT: {
                result = Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "policy/{kind}/list", AccountPolicyTO[].class, new Object[]{type}));
                break;
            }
            case PASSWORD: 
            case GLOBAL_PASSWORD: {
                result = Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "policy/{kind}/list", PasswordPolicyTO[].class, new Object[]{type}));
                break;
            }
            case SYNC: 
            case GLOBAL_SYNC: {
                result = Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "policy/{kind}/list", SyncPolicyTO[].class, new Object[]{type}));
                break;
            }
            default: {
                throw new IllegalArgumentException("Policy Type not supported: " + type);
            }
        }
        return result;
    }

    public <T extends PolicyTO> T read(PolicyType type, Long policyId) {
        return (T)((PolicyTO)this.getRestTemplate().getForObject(this.baseUrl + "policy/read/{id}.json", this.getTOClass(type), new Object[]{policyId}));
    }

    public <T extends PolicyTO> T readGlobal(PolicyType type) {
        return (T)((PolicyTO)this.getRestTemplate().getForObject(this.baseUrl + "policy/{kind}/global/read.json", this.getTOClass(type), new Object[]{this.typeToUrl(type)}));
    }

    public <T extends PolicyTO> void update(PolicyType type, Long policyId, T policyTO) {
        this.getRestTemplate().postForObject(this.baseUrl + "policy/{kind}/update", policyTO, policyTO.getClass(), new Object[]{this.typeToUrl(policyTO.getType())});
    }

    private <T extends PolicyTO> Class<T> getTOClass(PolicyType type) {
        Class<AccountPolicyTO> result = null;
        switch (type) {
            case ACCOUNT: 
            case GLOBAL_ACCOUNT: {
                result = AccountPolicyTO.class;
                break;
            }
            case PASSWORD: 
            case GLOBAL_PASSWORD: {
                result = PasswordPolicyTO.class;
                break;
            }
            case SYNC: 
            case GLOBAL_SYNC: {
                result = SyncPolicyTO.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Policy Type not supported: " + type);
            }
        }
        return result;
    }

    private String typeToUrl(PolicyType type) {
        String url = type.name().toLowerCase();
        int index = url.indexOf(95);
        return index == -1 ? url : url.substring(index + 1);
    }

    public Set<CorrelationRuleClassTO> getSyncCorrelationRuleClasses(PolicyType type) {
        Set result = Collections.emptySet();
        switch (type) {
            case SYNC: 
            case GLOBAL_SYNC: {
                result = CollectionWrapper.wrapSyncCorrelationRuleClasses(this.handlePossiblyEmptyStringCollection(this.baseUrl + "policy/syncCorrelationRuleClasses.json"));
                break;
            }
            default: {
                throw new NotFoundException();
            }
        }
        return result;
    }
}

