/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.JobHandler;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.runtime.Job;

public abstract class JobEntity
implements Serializable,
Job,
PersistentObject,
HasRevision {
    public static final boolean DEFAULT_EXCLUSIVE = true;
    public static final int DEFAULT_RETRIES = 3;
    private static final int MAX_EXCEPTION_MESSAGE_LENGTH = 255;
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected Date duedate;
    protected String lockOwner = null;
    protected Date lockExpirationTime = null;
    protected String executionId = null;
    protected String processInstanceId = null;
    protected String processDefinitionId = null;
    protected boolean isExclusive = true;
    protected int retries = 3;
    protected String jobHandlerType = null;
    protected String jobHandlerConfiguration = null;
    protected ByteArrayEntity exceptionByteArray;
    protected String exceptionByteArrayId;
    protected String exceptionMessage;

    public void execute(CommandContext commandContext) {
        ExecutionEntity execution = null;
        if (this.executionId != null) {
            execution = commandContext.getExecutionEntityManager().findExecutionById(this.executionId);
        }
        Map<String, JobHandler> jobHandlers = Context.getProcessEngineConfiguration().getJobHandlers();
        JobHandler jobHandler = jobHandlers.get(this.jobHandlerType);
        jobHandler.execute(this, this.jobHandlerConfiguration, execution, commandContext);
    }

    public void insert() {
        DbSqlSession dbSqlSession = Context.getCommandContext().getDbSqlSession();
        dbSqlSession.insert(this);
        if (this.executionId != null) {
            ExecutionEntity execution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.executionId);
            execution.addJob(this);
        }
    }

    public void delete() {
        DbSqlSession dbSqlSession = Context.getCommandContext().getDbSqlSession();
        dbSqlSession.delete(this);
        if (this.exceptionByteArrayId != null) {
            Context.getCommandContext().getByteArrayEntityManager().deleteByteArrayById(this.exceptionByteArrayId);
        }
        if (this.executionId != null) {
            ExecutionEntity execution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.executionId);
            execution.removeJob(this);
        }
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("lockOwner", this.lockOwner);
        persistentState.put("lockExpirationTime", this.lockExpirationTime);
        persistentState.put("retries", this.retries);
        persistentState.put("duedate", this.duedate);
        persistentState.put("exceptionMessage", this.exceptionMessage);
        if (this.exceptionByteArrayId != null) {
            persistentState.put("exceptionByteArrayId", this.exceptionByteArrayId);
        }
        return persistentState;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public void setExecution(ExecutionEntity execution) {
        this.executionId = execution.getId();
        this.processInstanceId = execution.getProcessInstanceId();
        execution.addJob(this);
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public String getExceptionStacktrace() {
        String exception = null;
        ByteArrayEntity byteArray = this.getExceptionByteArray();
        if (byteArray != null) {
            try {
                exception = new String(byteArray.getBytes(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ActivitiException("UTF-8 is not a supported encoding");
            }
        }
        return exception;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String claimedBy) {
        this.lockOwner = claimedBy;
    }

    public Date getLockExpirationTime() {
        return this.lockExpirationTime;
    }

    public void setLockExpirationTime(Date claimedUntil) {
        this.lockExpirationTime = claimedUntil;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public void setExclusive(boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Date getDuedate() {
        return this.duedate;
    }

    public void setDuedate(Date duedate) {
        this.duedate = duedate;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public void setExceptionStacktrace(String exception) {
        byte[] exceptionBytes = null;
        if (exception == null) {
            exceptionBytes = null;
        } else {
            try {
                exceptionBytes = exception.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ActivitiException("UTF-8 is not a supported encoding");
            }
        }
        ByteArrayEntity byteArray = this.getExceptionByteArray();
        if (byteArray == null) {
            byteArray = new ByteArrayEntity("job.exceptionByteArray", exceptionBytes);
            Context.getCommandContext().getDbSqlSession().insert(byteArray);
            this.exceptionByteArrayId = byteArray.getId();
            this.exceptionByteArray = byteArray;
        } else {
            byteArray.setBytes(exceptionBytes);
        }
    }

    public String getJobHandlerType() {
        return this.jobHandlerType;
    }

    public void setJobHandlerType(String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
    }

    public String getJobHandlerConfiguration() {
        return this.jobHandlerConfiguration;
    }

    public void setJobHandlerConfiguration(String jobHandlerConfiguration) {
        this.jobHandlerConfiguration = jobHandlerConfiguration;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage != null && exceptionMessage.length() > 255 ? exceptionMessage.substring(0, 255) : exceptionMessage;
    }

    public String getExceptionByteArrayId() {
        return this.exceptionByteArrayId;
    }

    private ByteArrayEntity getExceptionByteArray() {
        if (this.exceptionByteArray == null && this.exceptionByteArrayId != null) {
            this.exceptionByteArray = Context.getCommandContext().getDbSqlSession().selectById(ByteArrayEntity.class, this.exceptionByteArrayId);
        }
        return this.exceptionByteArray;
    }
}

