/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;

public class HistoricVariableInstanceEntity
implements ValueFields,
HistoricVariableInstance,
PersistentObject,
HasRevision,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String processInstanceId;
    protected String taskId;
    protected String executionId;
    protected String name;
    protected int revision;
    protected VariableType variableType;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected ByteArrayEntity byteArrayValue;
    protected String byteArrayValueId;
    protected Object cachedValue;

    public HistoricVariableInstanceEntity() {
    }

    public HistoricVariableInstanceEntity(VariableInstanceEntity variableInstance) {
        this.id = variableInstance.getId();
        this.processInstanceId = variableInstance.getProcessInstanceId();
        this.executionId = variableInstance.getExecutionId();
        this.taskId = variableInstance.getTaskId();
        this.revision = variableInstance.getRevision();
        this.name = variableInstance.getName();
        this.variableType = variableInstance.getType();
        this.copyValue(variableInstance);
    }

    public void copyValue(VariableInstanceEntity variableInstance) {
        this.textValue = variableInstance.getTextValue();
        this.textValue2 = variableInstance.getTextValue2();
        this.doubleValue = variableInstance.getDoubleValue();
        this.longValue = variableInstance.getLongValue();
        if (variableInstance.getByteArrayValueId() != null) {
            this.setByteArrayValue(variableInstance.getByteArrayValue().getBytes());
        }
    }

    public void delete() {
        this.deleteByteArrayValue();
        Context.getCommandContext().getDbSqlSession().delete(this);
    }

    @Override
    public Object getPersistentState() {
        ArrayList<Object> state = new ArrayList<Object>(5);
        state.add(this.textValue);
        state.add(this.textValue2);
        state.add(this.doubleValue);
        state.add(this.longValue);
        state.add(this.byteArrayValueId);
        return state;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public Object getValue() {
        if (!this.variableType.isCachable() || this.cachedValue == null) {
            this.cachedValue = this.variableType.getValue(this);
        }
        return this.cachedValue;
    }

    @Override
    public String getByteArrayValueId() {
        return this.byteArrayValueId;
    }

    public void setByteArrayValueId(String byteArrayValueId) {
        this.byteArrayValueId = byteArrayValueId;
        this.byteArrayValue = null;
    }

    @Override
    public ByteArrayEntity getByteArrayValue() {
        if (this.byteArrayValue == null && this.byteArrayValueId != null) {
            this.byteArrayValue = Context.getCommandContext().getDbSqlSession().selectById(ByteArrayEntity.class, this.byteArrayValueId);
        }
        return this.byteArrayValue;
    }

    @Override
    public void setByteArrayValue(byte[] bytes) {
        ByteArrayEntity byteArrayValue = null;
        if (this.byteArrayValueId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayEntityManager().deleteByteArrayById(this.byteArrayValueId);
        }
        if (bytes != null) {
            byteArrayValue = new ByteArrayEntity(bytes);
            Context.getCommandContext().getDbSqlSession().insert(byteArrayValue);
        }
        this.byteArrayValue = byteArrayValue;
        this.byteArrayValueId = byteArrayValue != null ? byteArrayValue.getId() : null;
    }

    protected void deleteByteArrayValue() {
        if (this.byteArrayValueId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayEntityManager().deleteByteArrayById(this.byteArrayValueId);
        }
    }

    @Override
    public String getVariableTypeName() {
        return this.variableType != null ? this.variableType.getTypeName() : null;
    }

    @Override
    public String getVariableName() {
        return this.name;
    }

    public VariableType getVariableType() {
        return this.variableType;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Long getLongValue() {
        return this.longValue;
    }

    @Override
    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    @Override
    public Double getDoubleValue() {
        return this.doubleValue;
    }

    @Override
    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    @Override
    public String getTextValue() {
        return this.textValue;
    }

    @Override
    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    @Override
    public String getTextValue2() {
        return this.textValue2;
    }

    @Override
    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    public void setByteArrayValue(ByteArrayEntity byteArrayValue) {
        this.byteArrayValue = byteArrayValue;
    }

    @Override
    public Object getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    public void setVariableType(VariableType variableType) {
        this.variableType = variableType;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }
}

