/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Event;

public class CommentEntityManager
extends AbstractManager {
    @Override
    public void delete(PersistentObject persistentObject) {
        this.checkHistoryEnabled();
        super.delete(persistentObject);
    }

    @Override
    public void insert(PersistentObject persistentObject) {
        this.checkHistoryEnabled();
        super.insert(persistentObject);
    }

    public List<Comment> findCommentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectCommentsByTaskId", taskId);
    }

    public List<Event> findEventsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectEventsByTaskId", taskId);
    }

    public void deleteCommentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        this.getDbSqlSession().delete("deleteCommentsByTaskId", taskId);
    }

    public List<Comment> findCommentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectCommentsByProcessInstanceId", processInstanceId);
    }

    protected void checkHistoryEnabled() {
        if (!this.getHistoryManager().isHistoryEnabled()) {
            throw new ActivitiException("In order to use comments, history should be enabled");
        }
    }
}

