/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.activiti.engine.runtime.Execution;

public class SignalEventReceivedCmd
implements Command<Void> {
    protected final String eventName;
    protected final String executionId;
    protected final Map<String, Object> variables;

    public SignalEventReceivedCmd(String eventName, String executionId, Map<String, Object> variables) {
        this.eventName = eventName;
        this.executionId = executionId;
        this.variables = variables;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        List<SignalEventSubscriptionEntity> signalEvents = null;
        if (this.executionId == null) {
            signalEvents = commandContext.getEventSubscriptionEntityManager().findSignalEventSubscriptionsByEventName(this.eventName);
        } else {
            ExecutionEntity execution = commandContext.getExecutionEntityManager().findExecutionById(this.executionId);
            if (execution == null) {
                throw new ActivitiObjectNotFoundException("Cannot find execution with id '" + this.executionId + "'", Execution.class);
            }
            if (execution.isSuspended()) {
                throw new ActivitiException("Cannot throw signal event '" + this.eventName + "' because execution '" + this.executionId + "' is suspended");
            }
            signalEvents = commandContext.getEventSubscriptionEntityManager().findSignalEventSubscriptionsByNameAndExecution(this.eventName, this.executionId);
            if (signalEvents.isEmpty()) {
                throw new ActivitiException("Execution '" + this.executionId + "' has not subscribed to a signal event with name '" + this.eventName + "'.");
            }
        }
        HashMap<String, Object> payload = null;
        if (this.variables != null) {
            payload = new HashMap<String, Object>(this.variables);
        }
        for (SignalEventSubscriptionEntity signalEventSubscriptionEntity : signalEvents) {
            if (!signalEventSubscriptionEntity.isGlobalScoped()) continue;
            signalEventSubscriptionEntity.eventReceived(payload, false);
        }
        return null;
    }
}

