/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.InputStream;
import java.io.Serializable;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.converter.util.InputStreamProvider;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.impl.util.io.BytesStreamSource;
import org.activiti.engine.repository.Deployment;

public class GetBpmnModelCmd
implements Command<BpmnModel>,
Serializable {
    private static final long serialVersionUID = 8167762371289445046L;
    protected String processDefinitionId;

    public GetBpmnModelCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public BpmnModel execute(CommandContext commandContext) {
        if (this.processDefinitionId == null) {
            throw new ActivitiIllegalArgumentException("processDefinitionId is null");
        }
        ProcessDefinitionEntity processDefinitionEntity = commandContext.getProcessDefinitionEntityManager().findProcessDefinitionById(this.processDefinitionId);
        if (processDefinitionEntity == null) {
            throw new ActivitiObjectNotFoundException("Process definition does not exist: " + this.processDefinitionId, ProcessDefinitionEntity.class);
        }
        String resourceName = processDefinitionEntity.getResourceName();
        ResourceEntity resource = commandContext.getResourceEntityManager().findResourceByDeploymentIdAndResourceName(processDefinitionEntity.getDeploymentId(), resourceName);
        if (resource == null) {
            if (commandContext.getDeploymentEntityManager().findDeploymentById(processDefinitionEntity.getDeploymentId()) == null) {
                throw new ActivitiObjectNotFoundException("deployment for process definition does not exist: " + processDefinitionEntity.getDeploymentId(), Deployment.class);
            }
            throw new ActivitiObjectNotFoundException("no resource found with name '" + resourceName + "' in deployment '" + processDefinitionEntity.getDeploymentId() + "'", InputStream.class);
        }
        BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
        return bpmnXMLConverter.convertToBpmnModel((InputStreamProvider)new BytesStreamSource(resource.getBytes()), false);
    }
}

