/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.util.ClockUtil;

public class AddCommentCmd
extends NeedsActiveTaskCmd<Object> {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String message;

    public AddCommentCmd(String taskId, String processInstanceId, String message) {
        super(taskId);
        this.processInstanceId = processInstanceId;
        this.message = message;
    }

    @Override
    protected Object execute(CommandContext commandContext, TaskEntity task) {
        String userId = Authentication.getAuthenticatedUserId();
        CommentEntity comment = new CommentEntity();
        comment.setUserId(userId);
        comment.setType("comment");
        comment.setTime(ClockUtil.getCurrentTime());
        comment.setTaskId(this.taskId);
        comment.setProcessInstanceId(this.processInstanceId);
        comment.setAction("AddComment");
        String eventMessage = this.message.replaceAll("\\s+", " ");
        if (eventMessage.length() > 163) {
            eventMessage = eventMessage.substring(0, 160) + "...";
        }
        comment.setMessage(eventMessage);
        comment.setFullMessage(this.message);
        commandContext.getCommentEntityManager().insert(comment);
        return null;
    }

    @Override
    protected String getSuspendedTaskException() {
        return "Cannot add a comment to a suspended task";
    }
}

