/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.components.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.activiti.spring.annotations.ActivitiComponent;
import org.activiti.spring.annotations.ProcessId;
import org.activiti.spring.annotations.ProcessVariable;
import org.activiti.spring.annotations.ProcessVariables;
import org.activiti.spring.annotations.State;
import org.activiti.spring.components.registry.ActivitiStateHandlerRegistration;
import org.activiti.spring.components.registry.ActivitiStateHandlerRegistry;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ActivitiStateAnnotationBeanPostProcessor
implements BeanPostProcessor,
BeanClassLoaderAware,
BeanFactoryAware,
InitializingBean,
Ordered {
    private volatile ActivitiStateHandlerRegistry registry;
    private volatile int order = Integer.MAX_VALUE;
    private volatile BeanFactory beanFactory;
    private volatile ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public int getOrder() {
        return this.order;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.beanClassLoader, (String)"beanClassLoader must not be null");
        Assert.notNull((Object)this.beanFactory, (String)"beanFactory must not be null");
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setRegistry(ActivitiStateHandlerRegistry registry) {
        this.registry = registry;
    }

    public Object postProcessAfterInitialization(final Object bean, final String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        final ActivitiComponent component = targetClass.getAnnotation(ActivitiComponent.class);
        ReflectionUtils.doWithMethods((Class)targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                String stateName;
                State state = (State)AnnotationUtils.getAnnotation((Method)method, State.class);
                String processName = component.processKey();
                if (StringUtils.hasText((String)state.process())) {
                    processName = state.process();
                }
                if (!StringUtils.hasText((String)(stateName = state.state()))) {
                    stateName = state.value();
                }
                Assert.notNull((Object)stateName, (String)"You must provide a stateName!");
                HashMap<Integer, String> vars = new HashMap<Integer, String>();
                Annotation[][] paramAnnotationsArray = method.getParameterAnnotations();
                int ctr = 0;
                int pvMapIndex = -1;
                int procIdIndex = -1;
                for (Annotation[] paramAnnotations : paramAnnotationsArray) {
                    ++ctr;
                    for (Annotation pa : paramAnnotations) {
                        if (pa instanceof ProcessVariable) {
                            ProcessVariable pv = (ProcessVariable)pa;
                            String pvName = pv.value();
                            vars.put(ctr, pvName);
                            continue;
                        }
                        if (pa instanceof ProcessVariables) {
                            pvMapIndex = ctr;
                            continue;
                        }
                        if (!(pa instanceof ProcessId)) continue;
                        procIdIndex = ctr;
                    }
                }
                ActivitiStateHandlerRegistration registration = new ActivitiStateHandlerRegistration(vars, method, bean, stateName, beanName, pvMapIndex, procIdIndex, processName);
                ActivitiStateAnnotationBeanPostProcessor.this.registry.registerActivitiStateHandler(registration);
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return null != AnnotationUtils.getAnnotation((Method)method, State.class);
            }
        });
        return bean;
    }
}

