/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.to;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.AbstractBaseBean;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlRootElement(name="BulkActionRes")
@XmlType
public class BulkActionRes
extends AbstractBaseBean {
    private List<Result> results;

    public void setResults(List<Result> results) {
        this.results = results;
    }

    public List<Result> getResults() {
        return this.results;
    }

    @JsonIgnore
    public void add(Object id, Status status) {
        if (this.results == null) {
            this.results = new ArrayList<Result>();
        }
        if (id != null) {
            this.results.add(new Result(id.toString(), status));
        }
    }

    @JsonIgnore
    public Map<String, Status> getResultMap() {
        HashMap<String, Status> res = new HashMap<String, Status>();
        if (this.results != null) {
            for (Result result : this.results) {
                res.put(result.getKey(), result.getValue());
            }
        }
        return res;
    }

    @JsonIgnore
    public List getResultByStatus(Status status) {
        ArrayList<String> res = new ArrayList<String>();
        if (this.results != null) {
            for (Result result : this.results) {
                if (result.getValue() != status) continue;
                res.add(result.getKey());
            }
        }
        return res;
    }

    public static class Result {
        private String key;
        private Status value;

        public Result() {
        }

        public Result(String key, Status value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Status getValue() {
            return this.value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(Status value) {
            this.value = value;
        }
    }

    @XmlEnum
    @XmlType(name="bulkActionStatus")
    public static enum Status {
        SUCCESS,
        FAILURE;

    }
}

