/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.repeater.data;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ListDataProvider<T extends Serializable>
implements IDataProvider<T> {
    private static final long serialVersionUID = 1L;
    private final List<T> list;

    public ListDataProvider() {
        this(Collections.emptyList());
    }

    public ListDataProvider(List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("argument [list] cannot be null");
        }
        this.list = list;
    }

    protected List<T> getData() {
        return this.list;
    }

    @Override
    public Iterator<? extends T> iterator(long first, long count) {
        long toIndex = first + count;
        List<T> list = this.getData();
        if (toIndex > (long)list.size()) {
            toIndex = list.size();
        }
        return list.subList((int)first, (int)toIndex).listIterator();
    }

    @Override
    public long size() {
        return this.getData().size();
    }

    @Override
    public IModel<T> model(T object) {
        return new Model<T>(object);
    }

    @Override
    public void detach() {
    }
}

