/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.WicketParseException;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.util.string.Strings;

public final class WicketTagIdentifier
extends AbstractMarkupFilter {
    private static Set<String> wellKnownTagNames;

    public WicketTagIdentifier(MarkupResourceStream markup) {
        super(markup);
    }

    @Override
    protected MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        String namespace = this.getWicketNamespace();
        String wicketIdValue = tag.getAttributes().getString(namespace + ":id");
        if (namespace.equalsIgnoreCase(tag.getNamespace())) {
            tag = new WicketTag(tag.getXmlTag());
            if (Strings.isEmpty((CharSequence)wicketIdValue)) {
                tag.setId(namespace + "_" + tag.getName());
                tag.setModified(true);
                if (!tag.isClose()) {
                    tag.setAutoComponentTag(true);
                }
            }
            if (!this.isWellKnown(tag)) {
                throw new WicketParseException("Unknown tag name with Wicket namespace: '" + tag.getName() + "'. Might be you haven't installed the appropriate resolver?", tag);
            }
        }
        if (wicketIdValue != null) {
            if (wicketIdValue.trim().length() == 0) {
                throw new WicketParseException("The wicket:id attribute value must not be empty. May be unmatched quotes?!?", tag);
            }
            tag.setId(wicketIdValue);
        }
        return tag;
    }

    public static final void registerWellKnownTagName(String name) {
        if (wellKnownTagNames == null) {
            wellKnownTagNames = new HashSet<String>();
        }
        String lowerCaseName = name.toLowerCase(Locale.ENGLISH);
        wellKnownTagNames.add(lowerCaseName);
    }

    private boolean isWellKnown(ComponentTag tag) {
        String lowerCaseTagName = tag.getName().toLowerCase(Locale.ENGLISH);
        return wellKnownTagNames.contains(lowerCaseTagName);
    }
}

