/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.upload;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.IMultipartWebRequest;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.upload.FileItem;

public class MultiFileUploadField
extends FormComponentPanel<Collection<FileUpload>> {
    private static final long serialVersionUID = 1L;
    public static final int UNLIMITED = -1;
    public static final String RESOURCE_LIMITED = "org.apache.wicket.mfu.caption.limited";
    public static final String RESOURCE_UNLIMITED = "org.apache.wicket.mfu.caption.unlimited";
    private static final String NAME_ATTR = "name";
    private static final String MAGIC_SEPARATOR = "_mf_";
    private static final ResourceReference JS = new JavaScriptResourceReference(MultiFileUploadField.class, "MultiFileUploadField.js");
    private final WebComponent upload;
    private final WebMarkupContainer container;
    private final int max;
    private final boolean useMultipleAttr;
    private transient String[] inputArrayCache = null;

    public MultiFileUploadField(String id) {
        this(id, null, -1);
    }

    public MultiFileUploadField(String id, int max) {
        this(id, null, max);
    }

    public MultiFileUploadField(String id, IModel<? extends Collection<FileUpload>> model) {
        this(id, model, -1);
    }

    public MultiFileUploadField(String id, IModel<? extends Collection<FileUpload>> model, int max) {
        this(id, model, max, false);
    }

    public MultiFileUploadField(String id, IModel<? extends Collection<FileUpload>> model, int max, boolean useMultipleAttr) {
        super(id, model);
        this.max = max;
        this.useMultipleAttr = useMultipleAttr;
        this.upload = new WebComponent("upload");
        this.upload.setOutputMarkupId(true);
        this.add(this.upload);
        this.container = new WebMarkupContainer("container");
        this.container.setOutputMarkupId(true);
        this.add(this.container);
        this.container.add(new Label("caption", new CaptionModel()));
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (tag.getAttributes().containsKey((Object)NAME_ATTR)) {
            tag.getAttributes().remove((Object)NAME_ATTR);
        }
    }

    @Override
    protected void onBeforeRender() {
        super.onBeforeRender();
        Form form = this.findParent(Form.class);
        if (form == null) {
            throw new IllegalStateException("Component " + this.getClass().getName() + " must have a " + Form.class.getName() + " component above in the hierarchy");
        }
    }

    @Override
    public boolean isMultiPart() {
        return true;
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        response.render(JavaScriptHeaderItem.forReference(JS));
        response.render(OnDomReadyHeaderItem.forScript("new MultiSelector('" + this.getInputName() + "', document.getElementById('" + this.container.getMarkupId() + "'), " + this.max + ", " + this.useMultipleAttr + ", '" + this.getString("org.apache.wicket.mfu.delete") + "').addElement(document.getElementById('" + this.upload.getMarkupId() + "'));"));
    }

    @Override
    public String[] getInputAsArray() {
        if (this.inputArrayCache == null) {
            ArrayList names = null;
            Request request = this.getRequest();
            if (request instanceof IMultipartWebRequest) {
                Map<String, List<FileItem>> itemNameToItem = ((IMultipartWebRequest)request).getFiles();
                for (Map.Entry<String, List<FileItem>> entry : itemNameToItem.entrySet()) {
                    String name = entry.getKey();
                    List<FileItem> fileItems = entry.getValue();
                    if (Strings.isEmpty((CharSequence)name) || !name.startsWith(this.getInputName() + MAGIC_SEPARATOR) || fileItems.isEmpty() || Strings.isEmpty((CharSequence)fileItems.get(0).getName())) continue;
                    names = names != null ? names : new ArrayList();
                    names.add(name);
                }
            }
            if (names != null) {
                this.inputArrayCache = names.toArray(new String[names.size()]);
            }
        }
        return this.inputArrayCache;
    }

    @Override
    protected Collection<FileUpload> convertValue(String[] value) throws ConversionException {
        ArrayList<FileUpload> uploads = null;
        String[] filenames = this.getInputAsArray();
        if (filenames != null) {
            IMultipartWebRequest request = (IMultipartWebRequest)this.getRequest();
            uploads = new ArrayList<FileUpload>(filenames.length);
            for (String filename : filenames) {
                List<FileItem> fileItems = request.getFile(filename);
                for (FileItem fileItem : fileItems) {
                    uploads.add(new FileUpload(fileItem));
                }
            }
        }
        return uploads;
    }

    @Override
    public void updateModel() {
        FormComponent.updateCollectionModel(this);
    }

    @Override
    protected void onDetach() {
        Collection uploads = (Collection)this.getConvertedInput();
        if (uploads != null) {
            for (FileUpload upload : uploads) {
                upload.closeStreams();
            }
        }
        this.inputArrayCache = null;
        Collection modelObject = (Collection)this.getModelObject();
        if (modelObject != null) {
            modelObject.clear();
        }
        super.onDetach();
    }

    private class CaptionModel
    extends AbstractReadOnlyModel<String> {
        private static final long serialVersionUID = 1L;

        private CaptionModel() {
        }

        @Override
        public String getObject() {
            if (MultiFileUploadField.this.max == -1) {
                return MultiFileUploadField.this.getString(MultiFileUploadField.RESOURCE_UNLIMITED);
            }
            HashMap<String, Integer> vars = new HashMap<String, Integer>(1);
            vars.put("max", MultiFileUploadField.this.max);
            return MultiFileUploadField.this.getString(MultiFileUploadField.RESOURCE_LIMITED, new Model(vars));
        }
    }
}

